import Qt 4.7

Rectangle {
    id: delegate

    signal delegateClicked
    signal delegatePressed

    width: delegate.ListView.view.width
    height: 100
    color: backgroundColor

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText
        elide: Text.ElideRight
        text: title
        color: textColor
        font.pixelSize: standardFontSize
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColorHigh
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}
