import Qt 4.7
import "scripts/settings.js" as Settings

Item {
    id: dialog

    signal close

    width: 600
    height: 230
    onStateChanged: {
        if (accountLoader.source != "") {
            accountLoader.item.state = dialog.state;
        }
    }

    Loader {
        id: accountLoader

        anchors.centerIn: dialog
        z: 1
        onLoaded: accountLoader.item.state = dialog.state

        Connections {
            target: accountLoader.item
            onClose: background.opacity = 1
            onAccountSaved: close()
        }
    }

    Item {
        id: background

        anchors.fill: dialog

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Rectangle {
            anchors.fill: background
            color: backgroundColor
            opacity: 0.5
            radius: 10
            border.width: 2
            border.color: activeColorHigh
        }

        Image {
            id: icon

            width: 120
            height: 120
            anchors { top: background.top; left: background.left; margins: 10 }
            smooth: true
            source: "ui-images/cutetubehires.png"

            Text {
                id: title

                anchors { bottom: icon.bottom; left: icon.right; margins: 10 }
                color: textColor
                font { pixelSize: 48; bold: true }
                text: qsTr("Hold it!")
            }
        }

        Text {
            id: description

            anchors { fill: background; leftMargin: 10; rightMargin: 180; topMargin: 140; bottomMargin: 10 }
            color: textColor
            font.pixelSize: standardFontSize
            wrapMode: TextEdit.WordWrap
            text: qsTr("cuteTube is currently downloading. Do you really want to exit?")
        }

        Column {
            anchors { right: background.right; bottom: background.bottom; margins: 10 }
            spacing: 10

            PushButton {
                id: yesButton

                showIcon: false
                showText: true
                name: qsTr("Yes")

                Connections {
                    onButtonClicked: Qt.quit()
                }
            }

            PushButton {
                id: noButton

                showIcon: false
                showText: true
                name: qsTr("No")

                Connections {
                    onButtonClicked: close();
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 400 }
        PropertyChanges { target: description; anchors.rightMargin: 10 }
        PropertyChanges { target: yesButton; width: 440 }
        PropertyChanges { target: noButton; width: 440 }
    }
}
