import Qt 4.7

Item {
    id: dialog

    signal saveClicked

    width: 600
    height: 295

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: title

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        font.pixelSize: smallFontSize
        color: "white"
        text: qsTr("New Playlist")
    }

    Column {
        id: column

        anchors { left: dialog.left; leftMargin: 10; right: dialog.right; rightMargin: 180; top: dialog.top; topMargin: 50 }
        spacing: 10

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: qsTr("Title")
        }

        Rectangle {
            height: 50
            width: column.width
            color:  "white"
            border.width: 2
            border.color: activeColorLow
            radius: 5

            TextInput {
                id: titleInput

                anchors { fill: parent; margins: 2 }
                focus: true
                font.pixelSize: standardFontSize
                selectByMouse: true
                selectionColor: activeColorLow
            }
        }

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: qsTr("Description (optional)")
        }

        Rectangle {
            height: 50
            width: column.width
            color:  "white"
            border.width: 2
            border.color: activeColorLow
            radius: 5

            TextInput {
                id: descriptionInput

                anchors { fill: parent; margins: 2 }
                font.pixelSize: standardFontSize
                selectByMouse: true
                selectionColor: activeColorLow
            }
        }

        Text {
            font.pixelSize: smallFontSize
            color: "grey"
            text: qsTr("Private?")

            CheckBox {
                id: checkbox
                checked: false

                anchors { left: parent.right; leftMargin: 10 }
            }
        }
    }

    PushButton {
        id: saveButton

        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"

        Connections {
            onButtonClicked: {
                if (titleInput.text != "") {
                    YouTube.createNewPlaylist(titleInput.text, descriptionInput.text, checkbox.checked);
                    saveClicked();
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 385 }
        PropertyChanges { target: column; anchors.rightMargin: 10 }
        PropertyChanges { target: saveButton; width: 440 }
    }
}
