import Qt 4.7
import "scripts/menu.js" as Menu

Rectangle {
    id: window

    signal goToPlaylist(string playlistId, string title)
//    signal playPlaylist(variant playlist)

    function showPlaylistDialog(index) {
        dialog.source = "PlaylistDialog.qml";
        dialog.item.infoClicked.connect(getPlaylistInfo);
        dialog.item.playClicked.connect(getPlaylistVideos);
        dialog.item.setPlaylist = playlistModel.get(index);
        playlists.state = "dim";
        playlists.interactive = false;
        mouseArea.enabled = true;
    }

    function getPlaylistInfo(playlistId, title) {
        goToPlaylist(playlistId, title);
        closeDialogs();
    }

    function getPlaylistVideos() {
        // TODO
    }

    function showNewPlaylistDialog() {
        dialog.source = "NewPlaylistDialog.qml";
        dialog.item.saveClicked.connect(closeDialogs);
        playlists.state = "dim";
        playlists.interactive = false;
        mouseArea.enabled = true;
    }

    function rotateDialogs() {
        if (dialog.source != "") {
            dialog.item.state = window.state;
        }
    }

    function closeDialogs() {
        /* Close any open dialogs and return the window to its default state */

        dialog.state = "";
        timer.running = true;
        playlists.state = "";
        mouseArea.enabled = false;
        playlists.interactive = true;
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: "black"
    onStateChanged: rotateDialogs()

    Connections {
        target:YouTube

        onPlaylistCreated: {
            displayMessage(qsTr("New playlist created"));
            playlistModel.reload();
        }
    }

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    ListView {
        id: playlists

        anchors { fill: window; topMargin: 50 }
        boundsBehavior: Flickable.DragOverBounds
        highlightMoveDuration: 500
        preferredHighlightBegin: 0
        preferredHighlightEnd: 100
        highlightRangeMode: playlists.state == "" ? ListView.StrictlyEnforceRange : ListView.NoHighlightRange
        interactive: visibleArea.heightRatio < 1

        footer: Rectangle {
            id: footer
            width: playlists.width
            height: 100
            color: "black"
            visible: playlistModel.status == XmlListModel.Loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: playlistModel

        delegate: PlaylistDelegate {
            id: delegate

            Connections {
                onDelegateClicked: goToPlaylist(playlistModel.get(index).playlistId, playlistModel.get(index).title);
//                onDelegatePressed: showPlaylistDialog(index);
            }
        }

        Loader {
            id: menuLoader

            z: 20
            width: playlists.width / 2
            anchors { left: playlists.left; bottom: playlists.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: qsTr("New playlist") } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        showNewPlaylistDialog();
                    }
                }
            }
        }

        Text {
            anchors.centerIn: playlists
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No playlists found")
            visible: (playlistModel.status == XmlListModel.Ready) && (playlists.count == 0)
        }

        ScrollBar {}

        MouseArea {
            id: mouseArea
            anchors.fill: playlists
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: playlists; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
