import Qt 4.7

Item {
    id: dialog

    property string fileToUpload

    property variant categoryList : [ [qsTr("Cars & Vehicles"), "Autos"], [qsTr("Comedy"), "Comedy"],
                                      [qsTr("Education"), "Education"], [qsTr("Entertainment"), "Entertainment"],
                                      [qsTr("Film and Animation"), "Film"], [qsTr("Gaming"), "Games"],
                                      [qsTr("Howto & Style"), "Howto"], [qsTr("Music"), "Music"], [qsTr("News & Politics"), "News"],
                                      [qsTr("Non-profits & Activism"), "Nonprofit"], [qsTr("People & Blogs"), "People"],
                                      [qsTr("Pets & Animals"), "Animals"], [qsTr("Science & Technology"), "Tech"],
                                      [qsTr("Sport"), "Sports"], [qsTr("Travel & Events"), "Travel"] ]

    signal uploadFinished

    function getCategory() {
        var category = qsTr("Entertainment");
        for (var i = 0; i < categoryList.length; i++) {
            if (categoryList[i][0] == categoryText.text) {
                category = categoryList[i][1];
            }
        }
        return category;
    }

    function showCategoryList() {
        var list = [];
        for (var i = 0; i < categoryList.length; i++) {
            list.push(categoryList[i][0]);
        }

        background.opacity = 0;
        dialogLoader.source = "SettingsListDialog.qml";
        dialogLoader.item.setSettingsList(qsTr("Category"), list, categoryText.text);
        dialogLoader.item.settingChosen.connect(setCategory);
        dialogLoader.item.close.connect(raiseOpacity);
        dialogLoader.item.opacity = 1;
    }

    function showFileChooser() {
        background.opacity = 0;
        dialogLoader.source = "FileChooserDialog.qml";
        dialogLoader.item.fileChosen.connect(setFilename);
        dialogLoader.item.close.connect(raiseOpacity);
        dialogLoader.item.opacity = 1;
    }

    function setFilename(filepath) {
        fileToUpload = filepath.substr(7);
        filenameText.text = filepath.split("/").pop();
    }

    function startUpload() {
        var title = titleInput.text;
        var description = descriptionInput.text;
        var tags = tagInput.text;
        var category = getCategory();
        var isPrivate = checkbox.checked;
        YouTube.uploadVideo(fileToUpload, title, description, tags, category, isPrivate);
        showUploadProgress(fileToUpload.split("/").pop(), title);
    }

    function showUploadProgress(filename, title) {
        background.opacity = 0;
        dialogLoader.source = "UploadProgressDialog.qml";
        dialogLoader.item.setDetails(filename, title);
        dialogLoader.item.close.connect(uploadFinished);
        dialogLoader.item.opacity = 1;
    }

    function setCategory(category) {
        categoryText.text = category;
    }

    function raiseOpacity() {
        background.opacity = 1;
    }

    function rotateDialogs() {
        if (dialogLoader.source != "") {
            dialogLoader.item.state = dialog.state;
        }
    }

    width: 600
    height: 300
    onStateChanged: rotateDialogs()

    Loader {
        id: dialogLoader

        anchors.centerIn: dialog
        z: 1
        onLoaded: dialogLoader.item.state = dialog.state
    }

    Item {
        id: background

        anchors.fill: dialog

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Rectangle {
            anchors.fill: background
            color: "black"
            opacity: 0.5
            radius: 10
            border.width: 2
            border.color: activeColor
            smooth: true
        }

        Text {
            id: title

            anchors { horizontalCenter: parent.horizontalCenter; top: parent.top; topMargin: 10 }
            font.pixelSize: smallFontSize
            color: "white"
            text: qsTr("Upload Video")
        }

        Flickable {
            id: flicker

            anchors { left: parent.left; leftMargin: 10; right: parent.right; rightMargin: 180; top: parent.top; topMargin: 50; bottom: parent.bottom; bottomMargin: 10 }

            contentWidth: 400
            contentHeight: 410
            clip: true
            flickableDirection: Flickable.VerticalFlick
            boundsBehavior: Flickable.DragOverBounds

            Column {
                id: column

                anchors.fill: parent
                spacing: 10

                Text {
                    font.pixelSize: smallFontSize
                    color: "grey"
                    text: qsTr("File")
                }

                Text {
                    id: filenameText

                    elide: Text.ElideRight
                    font.pixelSize: standardFontSize
                    color: fileMouseArea.pressed ? activeColor : activeColorLow
                    text: qsTr("None chosen")
                    smooth: true

                    MouseArea {
                        id: fileMouseArea

                        width: 200
                        height: 40
                        anchors.centerIn: parent
                        onClicked: showFileChooser()
                    }
                }

                Text {
                    font.pixelSize: smallFontSize
                    color: "grey"
                    text: qsTr("Title")
                }

                Rectangle {
                    height: 50
                    width: column.width
                    color:  "white"
                    border.width: 2
                    border.color: activeColorLow
                    radius: 5

                    TextInput {
                        id: titleInput

                        anchors { fill: parent; margins: 2 }
                        focus: true
                        font.pixelSize: standardFontSize
                        selectByMouse: true
                        selectionColor: activeColorLow
                    }
                }

                Text {
                    font.pixelSize: smallFontSize
                    color: "grey"
                    text: qsTr("Description (optional)")
                }

                Rectangle {
                    height: 50
                    width: column.width
                    color:  "white"
                    border.width: 2
                    border.color: activeColorLow
                    radius: 5

                    TextInput {
                        id: descriptionInput

                        anchors { fill: parent; margins: 2 }
                        font.pixelSize: standardFontSize
                        selectByMouse: true
                        selectionColor: activeColorLow
                    }
                }

                Text {
                    font.pixelSize: smallFontSize
                    color: "grey"
                    text: qsTr("Tags (seperated by commas)")
                }

                Rectangle {
                    height: 50
                    width: column.width
                    color:  "white"
                    border.width: 2
                    border.color: activeColorLow
                    radius: 5

                    TextInput {
                        id: tagInput

                        anchors { fill: parent; margins: 2 }
                        font.pixelSize: standardFontSize
                        selectByMouse: true
                        selectionColor: activeColorLow
                    }

                    Text {

                        anchors { top: parent.bottom; topMargin: 10; right: parent.right; rightMargin: 60 }
                        font.pixelSize: smallFontSize
                        color: "grey"
                        text: qsTr("Private?")

                        CheckBox {
                            id: checkbox
                            checked: false

                            anchors { left: parent.right; leftMargin: 10 }
                        }
                    }
                }

                Text {
                    font.pixelSize: smallFontSize
                    color: "grey"
                    text: qsTr("Category")

                    Text {
                        id: categoryText

                        anchors { top: parent.bottom; topMargin: 5 }
                        font.pixelSize: standardFontSize
                        color: categoryMouseArea.pressed ? activeColor : activeColorLow
                        text: qsTr("None chosen")
                        smooth: true

                        MouseArea {
                            id: categoryMouseArea

                            width: categoryText.width
                            height: 40
                            anchors.centerIn: parent
                            onClicked: showCategoryList()
                        }
                    }
                }
            }
        }

        PushButton {
            id: saveButton

            anchors { right: background.right; bottom: background.bottom; margins: 10 }
            icon: "ui-images/tick.png"

            Connections {
                onButtonClicked: {
                    if ((fileToUpload != "") && (titleInput.text != "")) {
                        startUpload();
                    }
                }
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 550 }
        PropertyChanges { target: flicker; contentWidth: 440 }
        PropertyChanges { target: flicker; anchors.rightMargin: 10 }
        PropertyChanges { target: saveButton; width: 440 }
    }
}
