import Qt 4.7

Rectangle {
    id: delegate

    signal delegateClicked(string searchterm)

    width: delegate.ListView.view.width
    height: 40
    color: "white"

    ListHighlight {
        visible: mouseArea.pressed
    }

    Rectangle {
        height: 1
        anchors { top: delegate.top; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
    }

    Text {
        id: titleText
        elide: Text.ElideRight
        text: searchterm
        color: "black"
        font.pixelSize: standardFontSize
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked(titleText.text)
    }
}
