import Qt 4.7
import "menu.js" as Menu

Rectangle {
    id: window

    property string uploadsFeed : "http://gdata.youtube.com/feeds/api/users/" + YouTube.currentUser  + "/uploads?v=2&max-results=50"
    property string favouritesFeed : "http://gdata.youtube.com/feeds/api/users/" + YouTube.currentUser  + "/favorites?v=2&max-results=50"

    signal uploads(string feed, string title)
    signal favourites(string feed, string title)
    signal playlists
    signal subscriptions

    function changeCurrentUser() {
        /* Raise a dialog enabling the user to choose from available users */

        if (dialog.source == "") {
            dialog.source = "ChangeUserDialog.qml";
            dialog.item.currentUserChanged.connect(closeDialogs)
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function showUploadDialog() {
        if (dialog.source == "") {
            dialog.source = "UploadDialog.qml";
            dialog.item.uploadFinished.connect(closeDialogs)
            dimmer.state = "dim";
            mouseArea.enabled = true;
        }
    }

    function rotateDialogs() {
        if (dialog.source != "") {
            dialog.item.state = window.state;
        }
    }

    function closeDialogs() {
        /* Close and destroy any open dialogs and return the window to its default state */

        dialog.state = "";
        timer.running = true;
        dimmer.state = "";
        mouseArea.enabled = false;
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: "black"
    onStateChanged: rotateDialogs()

    Connections {
        target: YouTube

        onUploadStarted: mouseArea.enabled = false;
    }

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show"
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Rectangle {
        id: dimmer

        anchors.fill: window
        color: window.color

        Loader {
            id: menuLoader

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: menuLoader.item.addMenuItems([ { name: qsTr("Upload video") } ])

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 0) {
                        showUploadDialog();
                    }
                }
            }
        }

        Grid {
            id: buttonGrid

            anchors.centerIn: dimmer
            rows: 2
            columns: 4
            spacing: 64

            Column {

                PushButton {
                    id: uploadsButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/uploadsicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: uploads(uploadsFeed, "My Uploads")
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: qsTr("Uploads")
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: favouritesButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/favouritesicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: favourites(favouritesFeed, "My Favourites")
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: qsTr("Favourites")
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: playlistsButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/playlistsicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: playlists()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: qsTr("Playlists")
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }

            Column {

                PushButton {
                    id: subscriptionsButton

                    width: 120
                    height: 120
                    smooth: true
                    icon: "ui-images/subscriptionsicon.png"
                    iconWidth: 100
                    iconHeight: 100

                    Connections {
                        onButtonClicked: subscriptions()
                    }
                }

                Text {
                    x: 0
                    y: 10
                    width: 120
                    text: qsTr("Subscriptions")
                    font.pixelSize: smallFontSize
                    color: "white"
                    horizontalAlignment: Text.AlignHCenter
                }
            }
        }

        Row {
            anchors { bottom: dimmer.bottom; bottomMargin: 80; right: dimmer.right; rightMargin: 64 }
            spacing: 5

            Text {
                font.pixelSize: smallFontSize
                color: "white"
                text: qsTr("Signed in as:")
            }

            Text {
                id: currentUserText

                font.pixelSize: smallFontSize
                color: userMouseArea.pressed ? activeColor : activeColorLow
                text: YouTube.currentUser

                MouseArea {
                    id: userMouseArea

                    width: 200
                    height: 70
                    anchors.centerIn: currentUserText
                    onClicked: changeCurrentUser()
                }
            }

        }

        MouseArea {
            id: mouseArea

            anchors.fill: dimmer
            enabled: false
            onClicked: closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

        transitions: Transition {
            PropertyAnimation { target: dimmer; properties: "opacity"; duration: 500 }
        }
    }

    states: State {
        name: "portrait"
        when: window.height > window.width
        PropertyChanges { target: buttonGrid; columns: 2 }
    }
}
