import Qt 4.7
import "settings.js" as Settings

Item {
    id: dialog

    function getAccounts() {
        /* Retrieve the user's accounts and populate the model */

        accountsModel.clear();
        var accounts = Settings.getAllAccounts();
        if (accounts != "unknown") {
            for (var i = 0; i < accounts.length; i++) {
                var username = accounts[i][0];
                accountsModel.append({ "username": username });
                if (username == YouTube.currentUser) {
                    accountsList.currentIndex = i;
                }
            }
        }
    }

    function deleteAccount() {
        /* Delete the account from the database and the list */

        var username = accountsModel.get(accountsList.currentIndex).username;
        var result = Settings.deleteAccount(username);
        if (result == "OK") {
            accountsModel.remove(accountsList.currentIndex);
            displayMessage("Account '" + username + "' deleted");
        }
        else {
            displayMessage("Database error. Unable to delete account");
        }
    }

    function rotateDialogs() {
        if (accountLoader.source != "") {
            accountLoader.item.state = dialog.state;
        }
    }

    width: 600
    height: 300
    onStateChanged: rotateDialogs()

    Component.onCompleted: getAccounts()

    Loader {
        id: accountLoader

        anchors.centerIn: dialog
        z: 1
        onLoaded: accountLoader.item.state = dialog.state

        Connections {
            target: accountLoader.item
            onClose: background.opacity = 1
            onAccountSaved: getAccounts()
        }
    }

    Item {
        id: background

        anchors.fill: dialog

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Rectangle {
            anchors.fill: background
            color: "black"
            opacity: 0.5
            radius: 10
            border.width: 2
            border.color: activeColor
        }

        Text {
            anchors { horizontalCenter: background.horizontalCenter; top: background.top; topMargin: 10 }
            text: qsTr("YouTube Accounts")
            font.pixelSize: smallFontSize
            color: "white"
        }

        Column {
            id: buttonColumn

            anchors { right: background.right; bottom: background.bottom; margins: 10 }
            spacing: 10

            PushButton {
                id: newButton

                icon: "ui-images/addicon.png"

                Connections {
                    onButtonClicked: {
                        background.opacity = 0;
                        accountLoader.source = "AccountDetailsDialog.qml";
                        accountLoader.item.opacity = 1;
                    }
                }
            }

            PushButton {
                id: editButton

                icon: "ui-images/pencilicon.png"
                disabled: true

                Connections {
                    onButtonClicked: {
                        background.opacity = 0;
                        accountLoader.source = "AccountDetailsDialog.qml";
                        accountLoader.item.getAccountDetails(accountsModel.get(accountsList.currentIndex).username);
                        accountLoader.item.opacity = 1;
                    }
                }
            }

            PushButton {
                id: deleteButton

                icon: "ui-images/deleteicon.png"
                disabled: true

                Connections {
                    onButtonClicked: deleteAccount()
                }
            }
        }

        ListView {
            id: accountsList

            anchors { fill: background; leftMargin: 10; rightMargin: 180; topMargin: 50; bottomMargin: 10 }
            clip: true
            interactive: visibleArea.heightRatio < 1

            model: ListModel {
                id: accountsModel
            }

            delegate: AccountDelegate {
                id: delegate

                Connections {
                    onDelegateClicked: {
                        accountsList.currentIndex = index;
                        editButton.disabled = false;
                        deleteButton.disabled = false;
                    }
                }
            }

            ScrollBar {}
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 510 }
        PropertyChanges { target: accountsList; anchors { rightMargin: 10; bottomMargin: 260 } }
        PropertyChanges { target: newButton; width: 440 }
        PropertyChanges { target: editButton; width: 440 }
        PropertyChanges { target: deleteButton; width: 440 }
    }
}
