import QtQuick 1.0

Item {
    id: dialog

    property string username
    property string id
    property string thumbnail
    property string subscriberCount
    property string videoCount
    property bool isSubscribed

    signal userVideosClicked(string username)
    signal close()

    function getUserProfile(user, subscribed) {
        username = user.title;
        id = user.subscriptionId.split(":")[5];
        isSubscribed = subscribed;

        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseXML.documentElement;
                for (var i = 0; i < xml.childNodes.length; i++) {
                    if (xml.childNodes[i].nodeName == "thumbnail") {
                        thumbnail = xml.childNodes[i].attributes[0].value;
                    }
                    else if (xml.childNodes[i].nodeName == "statistics") {
                        subscriberCount = xml.childNodes[i].attributes[1].value;
                    }
                    else if (xml.childNodes[i].nodeName == "feedLink") {
                        if (xml.childNodes[i].attributes[0].value == "http://gdata.youtube.com/schemas/2007#user.uploads") {
                            videoCount = xml.childNodes[i].attributes[2].value;
                        }
                    }
                }
            }
        }
        doc.open("GET", "http://gdata.youtube.com/feeds/api/users/" + username + "?v=2");
        doc.send();
    }

    width: 420
    height: 120

    Connections {
        target: YouTube

        onSubscribed: isSubscribed = true
        onUnsubscribed: isSubscribed = false
    }

    Rectangle {
        id: background

        color: "black"
        radius: 10
        opacity: 0.5
        anchors.fill: dialog
        border.width: 2
        border.color: activeColor
    }

    Row {
        spacing: 10
        anchors { left: dialog.left; leftMargin: 10; right: subscribeButton.left; rightMargin: 10; verticalCenter: dialog.verticalCenter }

        Rectangle {
            id: frame

            width: 100
            height: 100
            color: "black"
            border.width: 2
            border.color: mouseArea.pressed ? activeColorLow : "white"

            Image {
                id: thumb

                width: 94
                height: 94
                anchors.centerIn: frame
                source: thumbnail
                sourceSize.width: 88
                sourceSize.height: 88
                smooth: true

            }

            MouseArea {
                id: mouseArea

                anchors.fill: frame
                onClicked: userVideosClicked(username)
            }
        }

        Text {
            width: 200
            text: username
            color: "white"
            elide: Text.ElideRight
            font.pixelSize: smallFontSize

            Grid {
                id: textColumn

                width: 200
                anchors { left: parent.left; top: parent.bottom; topMargin: 5 }
                columns: 2
                spacing: 5

                Text {
                    text: "Subscribers"
                    color: "white"
                    elide: Text.ElideRight
                    font.pixelSize: smallFontSize
                }

                Text {
                    text: subscriberCount
                    color: "grey"
                    elide: Text.ElideRight
                    font.pixelSize: smallFontSize
                }

                Text {
                    text: "Videos"
                    color: "white"
                    elide: Text.ElideRight
                    font.pixelSize: smallFontSize
                }

                Text {
                    text: videoCount
                    color: "grey"
                    elide: Text.ElideRight
                    font.pixelSize: smallFontSize
                }
            }
        }

    }

    PushButton {
        id: subscribeButton

        anchors { right: dialog.right; rightMargin: 10; verticalCenter: dialog.verticalCenter }
        width: 100
        height: 100
        icon: isSubscribed ? "ui-images/unsubscribeicon.png" : "ui-images/subscriptionsicon.png"
        onButtonClicked: {
            YouTube.unsubscribeToChannel(id, username);
            close();
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: parent.verticalCenter } }
        }
    ]
    transitions: [
        Transition {
            AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
        }
    ]
}
