import QtQuick 1.0
import "videolistscripts.js" as Scripts
import "menu.js" as Menu

Rectangle {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
//    signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseText;
                videoListModel.setXml(xml);
            }
        }
        doc.open("GET", feed);
        doc.send();
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    color: "black"
    onStateChanged: Scripts.rotateDialogs()

    Connections {
        target: YouTube

        onAddedToPlaylist: videoListModel.reload()
    }

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: "Multi-select" } ]);
                if (menuLoader.pencilOn) {
                    menuLoader.item.addMenuItems([ { name: "Add to downloads" }, { name: "Add to favourites" }, { name: "Add to playlist" } ])
                }
            }

            onPencilOnChanged: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                if (!menuLoader.pencilOn) {
                    videoList.checkList = [];
                }
            }

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 1) {
                        Scripts.addVideosToDownloads();
                    }
                    else if (index == 2) {
                        if (userIsSignedIn) {
                            Scripts.addVideosToFavourites();
                        }
                    }
                    else if (index == 3) {
                        Scripts.showPlaylistDialog();
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            id: noResultsText

            anchors.centerIn: dimmer
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: "No videos found"
            visible: (videoListModel.status == XmlListModel.Ready) && (videoListModel.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 1000
            interactive: visibleArea.heightRatio < 1

            footer: Rectangle {
                id: footer
                width: videoList.width
                height: 100
                color: "black"
                visible: videoListModel.status == XmlListModel.Loading
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: PlaylistVideosModel {
                id: videoListModel
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 15)
                        && (videoList.count < videoListModel.totalResults)
                        && (videoListModel.status == XmlListModel.Ready)) {
                    Scripts.appendVideoFeed();
                }
            }

            delegate: VideoListDelegate {
                id: delegate

                function checkOrGoToVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        goToVideo(videoListModel.get(index));
                    }
                }

                checked: Scripts.indexInCheckList(index)

                Connections {
                    onDelegateClicked: checkOrGoToVideo()
                    onDelegatePressed: Scripts.showVideoDialog(index);
                }
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
