import QtQuick 1.0

Rectangle {
    id: delegate

    signal delegateClicked(string filepath)

    width: delegate.ListView.view.width
    height: 100
    color: "black"

    ListHighlight {
        visible: mouseArea.pressed
    }

    Image {
        anchors { left: delegate.left; leftMargin: 10; verticalCenter: delegate.verticalCenter }
        width: 50
        height: 50
        sourceSize.width: 50
        sourceSize.height: 50
        source: delegate.ListView.view.fmodel.isFolder(index) ? "ui-images/foldericon.png" : "ui-images/videosicon.png"
    }

    Text {
        id: titleText

        anchors { fill: delegate; leftMargin: 70; rightMargin: 10 }
        elide: Text.ElideRight
        text: fileName
        color: "white"
        font.pixelSize: standardFontSize
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked(filePath)
    }
}
