import QtQuick 1.0

Item {
    id: menu

    property alias showBackButton : backButton.visible
    property alias showQuitButton : quitButton.visible

    signal menuClicked
    signal menuHeld
    signal backClicked
    signal homeClicked
    signal quitClicked

    width: parent.width
    height: 60
    anchors.bottom: parent.bottom
    z: 3

    MenuButton {
        id: menuButton

        anchors.left: menu.left
        name: "Menu"

        Connections {
            onButtonClicked: menuClicked()
            onButtonPressed: menuHeld()
        }
    }

    Rectangle {
        id: separator
        width: 1
        height: 40
        anchors.centerIn: menu
        color: "white"
        opacity: 0.5
    }

    MenuButton {
        id: backButton

        anchors.right: menu.right
        name: "Back"

        Connections {
            onButtonClicked: backClicked()
            onButtonPressed: homeClicked()
        }
    }

    MenuButton {
        id: quitButton

        anchors.right: menu.right
        name: "Exit"

        Connections {
            onButtonClicked: quitClicked()
        }
    }
}


