import QtQuick 1.0

Item {
    id: menu

    signal newVideosClicked

    width: parent.width
    height: 60

    Rectangle {
        id: background

        anchors.fill: menu
        gradient: Gradient {
            GradientStop { position: 0.0; color: activeColor }
            GradientStop { position: 0.7; color: activeColorLow }
        }
        smooth: true
    }

    Row {
        anchors.horizontalCenter: menu.horizontalCenter

        MenuButton {
            id: newVideosButton
            icon: "ui-images/newsubvideosicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: newVideosClicked()
            }
        }
    }
}
