import QtQuick 1.0

Item {
    id: menu

    property alias pencilOn : pencilButton.buttonOn

    signal pencilClicked
    signal downloadClicked
    signal playClicked
    signal favouriteClicked
    signal addToPlaylistClicked

    width: parent.width
    height: menu.state == "portrait" && pencilButton.buttonOn ? 120 : 60
    anchors.bottom: parent.bottom

    Rectangle {
        id: background

        anchors.fill: menu
        color: "black"
        smooth: true
        opacity: 0.5
    }

    Grid {
        id: buttonGrid

        anchors.horizontalCenter: menu.horizontalCenter
        rows: 2
        columns: 6

        move: Transition {
            NumberAnimation { properties: "x", "y"; easing.type: Easing.OutQuart; duration: 500 }
        }

        MenuButton {
            id: playButton

            icon: "ui-images/playicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: playClicked()
            }
        }

        MenuButton {
            id: pencilButton

            icon: "ui-images/pencilicon.png"
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: pencilClicked()
            }
        }

        MenuButton {
            id: downloadButton

            icon: "ui-images/downloadicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false
            visible: pencilButton.buttonOn

            Connections {
                onButtonClicked: downloadClicked()
            }
        }

        MenuButton {
            id: favouriteButton

            icon: "ui-images/favouritesicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false
            visible: pencilButton.buttonOn

            Connections {
                onButtonClicked: favouriteClicked()
            }
        }

        MenuButton {
            id: playlistButton

            icon: "ui-images/playlistsicon.png"
            visible: pencilButton.buttonOn
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: addToPlaylistClicked()
            }
        }
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: buttonGrid; columns: 3 }
    }
}

