import QtQuick 1.0

Item {
    id: menu

    signal uploadClicked

    width: parent.width
    height: 60

    Rectangle {
        id: background

        anchors.fill: menu
        gradient: Gradient {
            GradientStop { position: 0.0; color: activeColor }
            GradientStop { position: 0.7; color: activeColorLow }
        }
        opacity: 0.7
        smooth: true
    }

    Row {
        anchors.horizontalCenter: menu.horizontalCenter

        MenuButton {
            id: uploadButton
            icon: "ui-images/uploadsicon.png"
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: uploadClicked()
            }
        }
    }
}

