/* Video list functions */

function appendVideoFeed() {
    var startIndex = videoList.count + 1;
    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            var xml = doc.responseText;
            videoListModel.appendXml(xml);
        }
    }
    doc.open("GET", videoFeed + "&start-index=" + startIndex);
    doc.send();
}

function showVideoDialog() {
    if (dialog.source == "") {
        dimmer.state = "dim";
        dialog.source = "VideoListDialog.qml";
        var video = videoListModel.get(videoList.currentIndex);
        dialog.item.setVideo(video);
        dialog.item.infoClicked.connect(goToVideo);
        dialog.item.close.connect(closeDialogs);
        videoList.interactive = false;
        mouseArea.enabled = true;
    }
}

function showPlaylistDialog() {
    if (dialog.source == "") {
        dimmer.state = "dim";
        dialog.source = "AddToPlaylistDialog.qml";
        dialog.item.playlistClicked.connect(addVideosToPlaylist);
        videoList.interactive = false;
        mouseArea.enabled = true;
    }
}

function addVideosToPlaybackQueue() {
    var list = [];
    for (var i = 0; i < videoList.checkList.length; i++) {
        var video = videoListModel.get(videoList.checkList[i]);
        list.push(video);
    }
    playVideos(list);
}

function addVideosToDownloads() {
    for (var i = 0; i < videoList.checkList.length; i++) {
        var video = videoListModel.get(videoList.checkList[i]);
        addDownload(video);
    }
}

function addVideosToPlaylist(playlistId) {
    closeDialogs();
    for (var i = 0; i < videoList.checkList.length; i++) {
        var videoId = videoListModel.get(videoList.checkList[i]).videoId;
        toggleBusy(true);
        YouTube.addToPlaylist(videoId, playlistId);
    }
}

function addVideosToFavourites() {
    for (var i = 0; i < videoList.checkList.length; i++) {
        var videoId = videoListModel.get(videoList.checkList[i]).videoId;
        toggleBusy(true);
        YouTube.addToFavourites(videoId);
    }
}

function rotateDialogs() {
    if (dialog.source != "") {
        dialog.item.state = window.state;
    }
}

function closeDialogs() {
    /* Close any open dialogs and return the window to its default state */

    dialog.state = "";
    timer.running = true;
    dimmer.state = "";
    mouseArea.enabled = false;
    videoList.interactive = true;
}

function showUserInfoDialog() {
    if (dialog.source == "") {
        dimmer.state = "dim";
        dialog.source = "UserInfoDialog.qml";
        dialog.item.subscribeClicked.connect(setSubscription);
        dialog.item.getUserProfile(username, isSubscribed);
        videoList.interactive = false;
        mouseArea.enabled = true;
    }
}

function setSubscription() {
    if (userIsSignedIn()) {
        toggleBusy(true);
        if (isSubscribed) {
            YouTube.unsubscribeToChannel(subscriptionId);
        }
        else {
            YouTube.subscribeToChannel(username);
        }
    }
    else {
        displayMessage("You are not signed in to a YouTube account");
    }
    closeDialogs();
}

function indexInCheckList(index) {
    var result = false;
    for (var i = 0; i < videoList.checkList.length; i ++) {
        if (videoList.checkList[i] == index) {
            result = true;
        }
    }
    return result;
}
