import QtQuick 1.0

Item {
    id: menu

    signal downloadClicked
    signal addToPlaylistClicked
    signal favouriteClicked
    signal rateClicked
    signal addCommentClicked

    width: parent.width
    height: 60

    Rectangle {
        id: background

        anchors.fill: menu
        gradient: Gradient {
            GradientStop { position: 0.0; color: activeColor }
            GradientStop { position: 0.7; color: activeColorLow }
        }
        opacity: 0.7
        smooth: true
    }

    Grid {
        id: buttonGrid

        anchors.horizontalCenter: menu.horizontalCenter
        rows: 2
        columns: 6

        move: Transition {
            NumberAnimation { properties: "x"; easing.type: Easing.OutQuart; duration: 500 }
        }

        MenuButton {
            id: downloadButton
            icon: "ui-images/downloadicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: downloadClicked()
            }
        }

        MenuButton {
            id: favouriteButton
            icon: "ui-images/favouritesicon.png"
            iconWidth: 60
            iconHeight: 60
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: favouriteClicked()
            }
        }

        MenuButton {
            id: playlistButton
            icon: "ui-images/playlistsicon.png"
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: addToPlaylistClicked()
            }
        }

        MenuButton {
            id: rateButton
            icon: "ui-images/ratevideo.png"
            iconWidth: 100
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: rateClicked()
            }
        }

        MenuButton {
            id: addCommentButton
            icon: "ui-images/commenticon.png"
            showLeftSeparator: false
            showRightSeparator: false

            Connections {
                onButtonClicked: addCommentClicked()
            }
        }
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: menu; height: 120 }
        PropertyChanges { target: buttonGrid;  columns: 3 }
    }
}
