import QtQuick 1.0

Rectangle {
    id: delegate

    property alias videoTitle: titleText.text
    property alias checked : checkbox.visible

    signal delegateClicked
    signal delegatePressed

    width: delegate.ListView.view.width; height: 100
    color: "black"
    smooth: true

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        elide: Text.ElideRight
        text: title
        color: "white"
        font.pixelSize: standardFontSize
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        verticalAlignment: Text.AlignTop
        smooth: true
    }

    Rectangle {
        id: frame

        width: 124
        height: 94
        anchors { left: delegate.left; leftMargin: 3; verticalCenter: delegate.verticalCenter }
        color: "black"
        border.width: 2
        border.color: "white"
        smooth: true
    }

    Image {
        id: thumb

        width: 120
        height: 90
        anchors.centerIn: frame
        source: thumb.status == Image.Error ? "ui-images/error.jpg" : thumbnail
        smooth: true
    }

    Row {
        id: labelRow

        anchors { left: frame.right; leftMargin: 10; bottom: frame.bottom }
        spacing: 5

//        LabelBox {
//            id: newLabel

//            name: "New"
//            opacity: isNew == 1 ? 1 : 0.3
//        }

        LabelBox {
            id: qualityLabel

            width: 120
            name: quality
            visible: quality != ""
        }
    }

    Image {
        id: checkbox

        width: 70
        height: 70
        source: "ui-images/tick.png"
        visible: false
        smooth: true
        anchors {
            verticalCenter: parent.verticalCenter
            right: parent.right
            rightMargin: 5
        }
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
        onPressAndHold: delegatePressed()
    }
}

