#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QObject>

class QWidget;

#include "qmlapplicationviewer.h"

class Controller : public QObject {
    Q_OBJECT
public:
    explicit Controller(QObject *parent = 0);

    void setView(QmlApplicationViewer* view);

public slots:

    void setOrientation(const QString &orient);
    void setMediaPlayer(const QString &player);
    void toggleState();
    void minimize();
    void playVideo(const QString &url);
    void deleteVideo(const QString &path);

private:
    QmlApplicationViewer* m_view;
    QString mediaPlayer;

signals:
    void alert(const QString &message);

};

#endif // CONTROLLER_H
