#ifndef STATIONSMANAGERS_H
#define STATIONSMANAGERS_H

#include <QtCore>
#include <QSortFilterProxyModel>

#include "listmodel.h"
#include "radiostation.h"

class StationsManagers : public QObject
{
    Q_OBJECT
public:
    explicit StationsManagers(QObject *parent = 0);
    ~StationsManagers();

    Q_INVOKABLE void clearModel();
    QAbstractItemModel* getModel();
    Q_INVOKABLE void addStation(QString name, QString freq, QString favorite);
    Q_INVOKABLE void deleteStation(int index);
    Q_INVOKABLE void updateStation(int index, QString name, QString freq, QString favorite);
    Q_INVOKABLE void populateModel();
    Q_INVOKABLE void setFavoriteFilter(QString value);
    Q_INVOKABLE void moveStationUp(int index);
    Q_INVOKABLE void moveStationDown(int index);
    
signals:
    
public slots:


private:
    ListModel *model;
    QSortFilterProxyModel *proxyModel;

    void saveModel();
    
};

#endif // STATIONSMANAGERS_H
