import QtQuick 1.1

Rectangle {
    id: root


    property alias text: textItem.text
    property alias fontFamily: textItem.font.family

    width: 195; height: 70

    signal clicked
    color: "transparent"
    border.color: "white"
    radius: 4

    Text {
        id: textItem
        anchors.centerIn: parent
        font.pointSize: 20
        color: "white"
    }
    Rectangle {
        anchors.fill: parent
        opacity: 0.15

    Rectangle {
        anchors.fill: parent
        z: -50
        gradient: Gradient {
            GradientStop { position: 0; color: "#00ffffff" }
            GradientStop { position: 0.5; color: "#ffffffff" }
            GradientStop { position: 0.99; color: "#00ffffff" }
        }
        visible: mouseArea.pressed
    }





    MouseArea {
             id: mouseArea
             anchors.fill: parent
             onClicked: {
                 root.clicked()

             }
    }

    states: State {
             name: "pressed"
             when: mouseArea.pressed == true
             PropertyChanges {
                 target: root
                 opacity: .6
             }
    }
    }
}
