#include "core.h"

const QString appVersion = "0.1.4";
const QString OS_Platform = "fremantle";

Core::Core(int &argc, char **argv) :
    QApplication(argc, argv)
{
    setApplicationName("QMLRadio");
    setOrganizationName("qmlradio");

    Settings* settings = new Settings(/*app.data()*/);
    StationsManagers *stationsManager = new StationsManagers(this);

    qmlRegisterType<BluetoothHeadsetAdapter>("it.ggiovanni88", 1, 0, "BluetoothHeadsetAdapter");
    qmlRegisterType<FMRadio>("it.ggiovanni88", 1, 0, "FMRadio");
    qmlRegisterType<WiredHeadsetAdapter>("it.ggiovanni88", 1, 0, "WiredHeadsetAdapter");
    qmlRegisterType<KeypadOnHelper>("it.ggiovanni88", 1, 0, "KeypadOnHelper");

    viewer = new QmlApplicationViewer();


#ifdef Q_WS_MAEMO_5
   // viewer->setAttribute(Qt::WA_Maemo5AutoOrientation);
    bool isHildon = true;
#else
   // viewer->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    bool isHildon = false;
#endif

    viewer->setAttribute(Qt::WA_OpaquePaintEvent);
    viewer->setAttribute(Qt::WA_NoSystemBackground);
    viewer->viewport()->setAttribute(Qt::WA_OpaquePaintEvent);
    viewer->viewport()->setAttribute(Qt::WA_NoSystemBackground);

    viewer->rootContext()->setContextProperty("viewer", viewer);
    viewer->rootContext()->setContextProperty("OS_Platform", QVariant::fromValue(QString(OS_Platform)));
    viewer->rootContext()->setContextProperty("appVersion", QVariant::fromValue(QString(appVersion)));
    viewer->rootContext()->setContextProperty("Settings", settings);
    viewer->rootContext()->setContextProperty("stationsManager", stationsManager);
    viewer->rootContext()->setContextProperty("stationsModel", stationsManager->getModel());
    viewer->rootContext()->setContextProperty("isHildon", isHildon);
    viewer->rootContext()->setContextProperty("appPath", QCoreApplication::applicationDirPath());

    viewer->setSource(QUrl::fromLocalFile(QString::fromLatin1("/%1/%2").arg(
                                                  QCoreApplication::applicationDirPath(), "qml/main.qml")));

    if(isHildon)
        viewer->showFullScreen();
    else
        viewer->show();

    XSetErrorHandler(myXErrorHandler);

    installEventFilter(this);
    viewer->showExpanded();

    XDamageQueryExtension(QX11Info::display(), &damage_event, &damage_error);
    _damage = XDamageCreate(QX11Info::display(), viewer->statusArea, XDamageReportNonEmpty);
}

Core::~Core()
{
    delete viewer;
    XDamageDestroy(QX11Info::display(), _damage);
}

bool Core::x11EventFilter(XEvent *event)
{
    if(event->type == damage_event + XDamageNotify)
    {
        const XDamageNotifyEvent *e = reinterpret_cast<const XDamageNotifyEvent*>(event);
        if(e->damage == _damage)
        {
            XDamageSubtract(QX11Info::display(), e->damage, None, None);
            viewer->updateStatusArea();
        }
    }

    return false;
}
