/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef V4LRADIOCONTROL_H
#define V4LRADIOCONTROL_H

#include <QtCore/qobject.h>
#include <QtCore/qtimer.h>

#include <qradiotunercontrol.h>

#include <QtDBus/QtDBus>
#include <gst/gst.h>

#include <alsa/asoundlib.h>

QT_USE_NAMESPACE

class V4LRadioService;

class V4LRadioControl : public QRadioTunerControl
{
    Q_OBJECT
public:
    V4LRadioControl(QObject *parent = 0);
    ~V4LRadioControl();

    bool isAvailable() const;
    QtMultimediaKit::AvailabilityError availabilityError() const;

    QRadioTuner::State state() const;

    QRadioTuner::Band band() const;
    void setBand(QRadioTuner::Band b);
    bool isBandSupported(QRadioTuner::Band b) const;

    int frequency() const;
    int frequencyStep(QRadioTuner::Band b) const;
    QPair<int,int> frequencyRange(QRadioTuner::Band b) const;
    void setFrequency(int frequency);

    bool isStereo() const;
    QRadioTuner::StereoMode stereoMode() const;
    void setStereoMode(QRadioTuner::StereoMode mode);

    int signalStrength() const;

    int volume() const;//speaker volume
    void setVolume(int volume);//speaker volume

    bool isMuted() const;
    void setMuted(bool muted);

    bool isSearching() const;
    void cancelSearch();

    void searchForward();
    void searchBackward();

    void start();
    void stop();

    QRadioTuner::Error error() const;
    QString errorString() const;



    void busCall(GstMessage *message);
    void onStateChanged(GstMessage *message);
    void setSpeakerVolume(int volume);



    void radioMixerDisable();
    void radioMixerEnable();

public slots:
    void enablePipeline(bool enable = true);
    void setupSpeaker();
    void setupHeadPhone();

private slots:
    void search();
    void enableFMRX();
    void onBusTimer();

private:
    bool initRadio();
    bool createGstPipeline();
    void callAmixer(const QString& target, const QString& value);
    int getEnumItemIndex(snd_ctl_t *handle, snd_ctl_elem_info_t *info, const  QString &value);
    int vol(snd_hctl_elem_t *elem) const;

private:
    int fd;

    bool m_error;
    bool muted;
    bool stereo;
    bool low;
    bool available;
    bool initPipeline;
    bool allowNullState;
    int  tuners;
    int  step;
    int  sig;
    bool scanning;
    bool forward;
    QTimer* timer;
    QTimer* tickTimer;
    QRadioTuner::Band   currentBand;
    qint64 freqMin;
    qint64 freqMax;
    qint64 currentFreq;

    GstElement *pipeline;

    GstElement *source, *sink;

    QDBusInterface* FMRXEnablerIFace;

    GstBus *gstbus;

    QTimer *busTimer;
};

#endif
