#ifndef RADIOSTATION_H
#define RADIOSTATION_H

#include <QtCore>

#include "listmodel.h"

class RadioStation : public ListItem
{
    Q_OBJECT
public:
    explicit RadioStation(QObject *parent = 0);
    explicit RadioStation(QString name, QString freq, QString favorite, QObject *parent = 0);

    enum Roles {
          NameRole = Qt::UserRole+1,
          FreqRole,
          FavoriteRole
      };

    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;

    inline QString id() const { return m_name; }
    inline QString name() const { return m_name; }
    inline QString freq() const { return m_freq; }
    inline QString favorite() const { return m_favorite; }
    void setValues(QString name, QString freq, QString favorite);


private:
    QString m_name;
    QString m_freq;
    QString m_favorite;
    

signals:
    
public slots:
    
};

#endif // RADIOSTATION_H
