import QtQuick 1.1

Item {
    id: rootButton
    width: parent.width
    height: 50
    signal clicked()
    signal switchChecked(bool checked)
    property alias text: txt.text
    property bool checked
    Rectangle {
        id: rec
        height: 40
        color: "transparent"
        width: parent.width - 10
        radius: 4
        anchors.verticalCenter: parent.verticalCenter
    }
    Rectangle {
        id: border
        height: 40
        color: "transparent"
        //border.color: "lightBlue"
        width: rec.width
        radius: 4
        anchors.verticalCenter: parent.verticalCenter
    }
    Text {
        id: txt
        anchors.verticalCenter: parent.verticalCenter
        font.pixelSize: 20
        anchors.left: parent.left
        anchors.leftMargin: 20
        color: "white"
    }
    Rectangle {
        id: switcher
        width: 80
        anchors.verticalCenter: parent.verticalCenter
        border.color: "black"
        color: "transparent"
        opacity: 0.8
        height: 40
        radius: 14
        anchors.right: parent.right
        anchors.rightMargin: 20
        smooth: true
        Rectangle {
            id: rec2
            x: 2
            width: switcher.width / 2.2
            height: width
            color: "grey"
            smooth: parent.smooth
            radius: parent.radius
            state: checked ? "enabled" : "disabled"
            opacity: 0.8
            anchors.verticalCenter: switcher.verticalCenter
            Behavior on x {
                NumberAnimation {
                }
            }
            Behavior on color {
                ColorAnimation {
                }
            }
            states: [
                State {
                    name: "disabled"
                    PropertyChanges {
                        target: rec2
                        x: 2
                    }
                },
                State {
                    name: "enabled"
                    PropertyChanges {
                        target: rec2
                        x: switcher.width - rec2.width - 2
                        color: "SteelBlue"
                    }
                }
            ]
        }
        MouseArea {
            id: recM
            anchors.fill: parent
            anchors.margins: -5
            onClicked: {
                rootButton.clicked()
                if (rec2.state == "disabled") {
                    rec2.state = "enabled"
                } else {
                    rec2.state = "disabled"
                }
                switchChecked(!checked)
            }
        }
    }
    Rectangle {
        anchors.fill: switcher
        radius: switcher.radius
        color: "black"
        opacity: 0.2
        smooth: true
        border.color: "white"
    }
}
