#include "modelmanager.h"

ModelManager::ModelManager(QObject *parent) :
    QObject(parent)
{
    createModel();
}

ModelManager::~ModelManager()
{
    saveStationsList();
    qDebug() << "In ModelManager destructor";
}

ListModel* ModelManager::createModel()
{
    model = new ListModel(new StationItem, qApp);

    QStringList stations = readStationsList();
    QString station;
    QString name;
    QString freq;

    for (int i=0; i<stations.size(); i++)
    {
        station = stations.at(i);
        name = station.split("---").at(0);
        freq = station.split("---").at(1);

        model->appendRow(new StationItem(name, freq, model));
    }


    qDebug() << "Model size: " << model->rowCount();
    return model;
}

ListModel * ModelManager::getModel()
{
    return model;
}

void ModelManager::addStation(QString name, QString freq)
{
    model->appendRow(new StationItem(name, freq));
}

QString ModelManager::getQuickAccessFreq1()
{
    QSettings settings("qmlradio", "settings");
    return settings.value("quickAccessFreq1", "99.200").toString();
}

QString ModelManager::getQuickAccessFreq2()
{
    QSettings settings("qmlradio", "settings");
    return settings.value("quickAccessFreq2", "103.200").toString();
}

void ModelManager::setQuickAccessFreq1(QString freq)
{
    QSettings settings("qmlradio", "settings");
    settings.setValue("quickAccessFreq1", freq);
}

void ModelManager::setQuickAccessFreq2(QString freq)
{
    QSettings settings("qmlradio", "settings");
    settings.setValue("quickAccessFreq2", freq);
}

void ModelManager::saveStationsList()
{
    QStringList stations;
    QString station;
    StationItem* item;

    for (int i=0; i<model->rowCount(); i++)
    {
        item = dynamic_cast<StationItem*>( model->itemAt(i) );
        station = QString("%1---%2").arg( item->name() ).arg( item->freq() );
        stations.append(station);
    }

    qDebug() << stations;

    QSettings settings("qmlradio", "settings");
    settings.setValue("stationsList", stations);
}

QStringList ModelManager::getDefaultList()
{
    QStringList stations;
    stations.append("Station1---99.100");
    stations.append("Station2---88.100");
    stations.append("Station3---102.100");
    stations.append("Station4---105.100");
    stations.append("Station5---107.100");

    return stations;
}

QStringList ModelManager::readStationsList()
{
    QSettings settings("qmlradio", "settings");
    return settings.value("stationsList", getDefaultList()).toStringList();
}
