import QtQuick 1.1
import Qt.labs.gestures 1.0
import Qt 4.7


Rectangle {
    id: qmlRadio
    width: 800
    height: 480

    gradient: Gradient {
        GradientStop { position: 0.0;  color:  "black" }
        GradientStop { id: gradientColor; position: 0.66; color: "black"; Behavior on color {
                ColorAnimation {}
            } }
        GradientStop { position: 1.0; color: "black" }
    }


    SwipeGestureArea {
        id: swipeArea
        objectName: "swipeArea"
        anchors.fill: parent
    }

    MenuBar {
        id: menuBar
    }

    Button {
        id: startRadioButton
        x: 480
        y: 1
        width: 147
        height: 58
        radius: 10
        text: "Start Radio"
        z: 1
        visible: true
        onButtonClicked: {
            if (!radio.isRadioActive()) {
                radio.startRadio()
            }

            if (radio.isRadioActive()) {
                qmlRadio.state = "RadioActive"
                infoBanner.show("FM Radio started")
            }
            else {
                if (!radio.isHeadphoneConnected()) {
                    console.debug("QML: no headphones")
                    infoBanner.show("Insert headphones to start FM Radio")
                }
            }
        }




        Behavior on y {
                 NumberAnimation {
                         easing {
                         type: Easing.InCirc
                         amplitude: 1.0
                         period: 3
                     }
                 }
        }
    }

    Button {
        id: stopRadioButton
        x: 480
        y: -200
        width: 147
        height: 58
        text: "Stop Radio"
        clip: false
        visible: true
        opacity: 1
        onButtonClicked: {
            radio.stopRadio()
            if (!radio.isRadioActive()) {
                qmlRadio.state = "base state"
                infoBanner.show("FM Radio stopped")
            }
        }


        Behavior on y {
                 NumberAnimation {
                         easing {
                         type: Easing.InCirc
                         amplitude: 1.0
                         period: 3
                     }
                 }
        }
    }


    InfoBanner {
        id: infoBanner
        z: 10
    }


    StationsList {
        id: stationsList
        x: 900
        y: 74
        height: 300

        onStationPicked: {
            console.debug("Station picked: " + freq)
            radio.setFreq(freq)


        }

        Behavior on x {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 0.5
                         period: 3
                     }
                 }
        }
    }



    FrequencyLabel {
        id: frequencyLabel
        objectName: "frequencyLabel"
        x: -400
        y: 106

        Behavior on x {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 0.5
                         period: 3
                     }
                 }
        }
    }

    Row {
        id: row1
        x: 58
        y: 493
        visible: true
        opacity: 1
        spacing: 15


        Behavior on y {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 1.0
                         period: 3
                     }
                 }
        }


        Button {
            id: button1
            text: "Scan Down"
            onButtonClicked: radio.scanDown()
        }

        Button {
            id: button2
            text: "Freq Down"
            onButtonClicked: radio.freqDown()


        }

        Button {
            id: button3
            text: "Freq Up"
            onButtonClicked: radio.freqUp()
        }

        Button {
            id: button4
            text: "Scan Up"
            onButtonClicked: radio.scanUp()
        }


    }

    AddStationButton {
        id: addStationButton
        x: -366
        y: 245

        Behavior on x {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 0.5
                         period: 3
                     }
                 }
        }
    }

    QuickAccessButton {
        id: quickButton1
        x: -294
        y: 245

        freqText: modelManager.getQuickAccessFreq1()

        onButtonClicked: radio.setFreq(freqText)
        onButtonHold: {
            freqText = radio.getFreq()
            modelManager.setQuickAccessFreq1(radio.getFreq())
        }

        Behavior on x {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 1.0
                         period: 3
                     }
                 }
        }
    }

    QuickAccessButton {
        id: quickButton2
        x: -172
        y: 245

        freqText: modelManager.getQuickAccessFreq2()

        onButtonClicked: radio.setFreq(freqText)
        onButtonHold: {
            freqText = radio.getFreq()
            modelManager.setQuickAccessFreq2(radio.getFreq())
        }

        Behavior on x {
                 NumberAnimation {
                         easing {
                         type: Easing.OutElastic
                         amplitude: 1.0
                         period: 3
                     }
                 }
        }
    }


    states: [
        State {
            name: "RadioActive"

            PropertyChanges {
                target: stopRadioButton
                x: 480
                y: 1
                width: 147
                height: 58
                visible: true
            }

            PropertyChanges {
                target: startRadioButton
                x: 480
                y: -200
                width: 147
                visible: true
            }

            PropertyChanges {
                target: row1
                x: 58
                y: 386
            }

            PropertyChanges {
                target: gradientColor
                color: "#112233"

            }

            PropertyChanges {
                target: frequencyLabel
                x: 35
            }

            PropertyChanges {
                target: stationsList
                x: 468
                y: 74
            }

            PropertyChanges {
                target: addStationButton
                x: 35
            }

            PropertyChanges {
                target: quickButton1
                x: 109
                y: 245
            }

            PropertyChanges {
                target: quickButton2
                x: 234
                y: 245
            }


        }
    ]


}
