import QtQuick 1.0

MouseArea {
    id: swipeGestureArea
    signal swipeRight;
    signal swipeLeft;
    signal swipeUp;
    signal swipeDown;

    property int startX;
    property int startY;


    onPressed: {
        startX = mouse.x;
        startY = mouse.y;
    }

    onReleased: {
    var deltax = mouse.x - startX;
    var deltay = mouse.y - startY;

    if (Math.abs(deltax) > 50 || Math.abs(deltay) > 50) {
        if (deltax > 30 && Math.abs(deltay) < 30) {
            // swipe right
            swipeRight();
            infoBanner.show("hello");
            console.debug("Swipe right")
        } else if (deltax < -30 && Math.abs(deltay) < 30) {
            // swipe left
            swipeLeft();
            modelManager.addStation("test", radio.getFreq());
        } else if (Math.abs(deltax) < 30 && deltay > 30) {
            // swipe down
            swipeDown();
        } else if (Math.abs(deltax) < 30 && deltay < 30) {
            // swipe up
            swipeUp();
        }
    }
     }
}
