import QtQuick 1.0

 Rectangle {
     id: container

     property string inputText: textInput.text
     signal closed
     width: 300
     height: 100
     radius: 15
     color: "#99000000"

     function show(text) {
         dialogText.text = text;
         container.opacity = 1;
         textInput.opacity = 0;
     }

     function showWithInput(text) {
         show(text);
         textInput.opacity = 1;
         textInput.focus = true;
         textInput.text = ""
     }

     function hide() {
         textInput.focus = false;
         container.opacity = 0;
         container.closed();
     }

     opacity: 0
     visible: opacity > 0

     Rectangle {
         id: textInputBackground
         color: "black"
         border.color: "blue"
         width:  300
         height: 50
         radius:  12
         anchors.bottom: parent.bottom
     }

     Text {
         id: dialogText
         anchors { top: parent.top; topMargin: 10; left: parent.left; leftMargin: 10 }
         text: "text"
         color: "white"
     }

     TextInput {
         id: textInput
         anchors { centerIn: textInputBackground}
         text: "text input pqtest"
         color: "white"


         onAccepted: container.hide()    // close dialog when Enter is pressed
     }

     MouseArea {
         anchors.fill: parent

         onClicked:  {
             if (textInput.text == "" && textInput.opacity > 0)
                 textInput.openSoftwareInputPanel();
             else
                 hide();
         }
     }

 }
