/*
 * testwindow.h -  header of test application of vktransport for QMF-Vkontakte plug-in
 * This file is part of QMF-Vkontakte plug-in.
 *
 * Copyright (C) 2010 - Nikolai Agafonov
 *
 * QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QMF-Vkontakte plug-in; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef TESTWINDOW_H
#define TESTWINDOW_H
#include <QObject>
#include <QWidget>
#include <QtGui>

class QVBoxLayout;
class QHBoxLayout;
class QTextEdit;
class QPushButton;
class QLineEdit;
class QLabel;
class TestWindow:public QWidget {
    Q_OBJECT
    public:
        TestWindow(QWidget * parent = 0);
        ~TestWindow();

    private:
        QTextEdit* inputTextfield;
        QTextEdit* outputTextfield;
        QPushButton* initButton;
        QPushButton* setSettingsButton;
        QPushButton* getSettingsButton;
        QPushButton* getSendButton;
        QPushButton* getInboxButton;
        QPushButton* sendMessageButton;
        QPushButton* deleteMessageButton;
        QPushButton* getNewInboxButton;
        QPushButton* exitButton;
        QPushButton* getProfileButton;
        QVBoxLayout* buttonLayout;
        QVBoxLayout* fieldsLayout;
        QVBoxLayout* textLayout;
        QHBoxLayout* mainLayout;
        QLabel* loginLabel;
        QLabel* passwordLabel;
        QLabel* autoupdateLabel;
        QLabel* activityLabel;
        QLabel* proxyHostLabel;
        QLabel* proxyPortLabel;
        //QLabel* recipientIdLabel;
        //QLabel* messageLabel;
        QLineEdit* loginLine;
        QLineEdit* passwordLine;
        QLineEdit* autoupdateLine;
        QLineEdit* activityLine;
        QLineEdit* proxyHostLine;
        QLineEdit* proxyPortLine;
        QLineEdit* recipientIdEdit;
        QLineEdit* messageIdEdit;
        //QLineEdit* recipientIdLine;
       // QTextEdit* messageText;
    public slots:
        void init();
        void setSettings();
        void getSettings();
        void getSend();
        void getInbox();
        void sendMessage();
        void deleteMessage();
        void getNewInbox();
	void getProfile();

};
#endif // TESTWINDOW_H
