TEMPLATE = lib
TARGET = vk
CONFIG += qmfclient qmfmessageserver plugin debug link_pkgconfig
QT = core network

#Depends on
# libxml - http://xmlsoft.org/downloads.html
# glib - http://www.gtk.org/download.html
# libfacebook - http://www.gitorious.org/mysocials/libfacebook
# qmfclient qmfmessageserver - http://qt.gitorious.org/qt-labs/messagingframework
PKGCONFIG += libxml-2.0 glib-2.0 mysocials-dev  qmfclient qmfmessageserver

# message(Qt $$[QT_VERSION] is installed in $$[QT_INSTALL_PREFIX])

# if exists path to plugins (not variable)
exists($$(QMF_PLUGINS)) {
    target.path = $$(QMF_PLUGINS)/messageservices
} else {
    isEmpty(QMF_INSTALL_ROOT) {
        QMF_INSTALL_ROOT = /usr/local
#       QMF_INSTALL_ROOT = /usr
    }
    target.path += $$QMF_INSTALL_ROOT/plugins/messageservices
#   target.path = $$QMF_INSTALL_ROOT/lib/qt4/plugins/messageservices
}
DEPENDPATH += .
INCLUDEPATH += . 


HEADERS += vkclient.h \
           vkconfiguration.h \
           vkservice.h \
           vktransport.h

SOURCES += vkclient.cpp \
           vkconfiguration.cpp \
           vkservice.cpp \
           vktransport.cpp

!contains(DEFINES,QMF_NO_MESSAGE_SERVICE_EDITOR) {
QT += gui

HEADERS += \
           vksettingssource.h \
           vksettingssink.h

FORMS += \
         vksettingssource.ui \
         vksettingssink.ui

SOURCES += \
           vksettingssource.cpp \
           vksettingssink.cpp
}

CONFIG(debug,debug|release) {
    DEFINES += QMF_ENABLE_LOGGING
}

INSTALLS += target

include(../common.pri)

plugin {
    DEFINES += PLUGIN_INTERNAL
}

qmfclient:qtAddLibrary(qmfclient)
qmfmessageserver:qtAddLibrary(qmfmessageserver)
qmfutil:qtAddLibrary(qmfutil)






