/*
 * testwindow.cpp - test application of vktransport for QMF-Vkontakte plug-in
 * This file is part of QMF-Vkontakte plug-in.
 *
 * Copyright (C) 2010 - Nikolai Agafonov
 *
 * QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QMF-Vkontakte plug-in; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include "testwindow.h"
#include "vktransport.h"
#include <QApplication>

VkTransport vk;

void TestWindow::init(){
    vk.vkInit(proxyHostLine->text().toStdString().c_str(),
              proxyPortLine->text().toInt());
}

void TestWindow::setSettings(){
    vk.vkSetSettings(loginLine->text().toStdString().c_str(),
              passwordLine->text().toStdString().c_str());
}

void TestWindow::getSettings(){
    vk.vkGetSettings();
}

void TestWindow::getSend(){
    vk.vkGetSend();
}


void TestWindow::getInbox(){
    vk.vkGetInbox();
}

void TestWindow::sendMessage(){
    vk.vkSendMessage(recipientIdEdit->text().toStdString().c_str(),
                     (outputTextfield->toPlainText().toStdString().c_str()));
}

void TestWindow::deleteMessage(){
    vk.vkDeleteMessage(messageIdEdit->text().toStdString().c_str());
}

void TestWindow::getNewInbox(){
    vk.vkGetNewInbox();
}

void TestWindow::getProfile(){
    vk.vkGetProfile();
}


// Constructor
TestWindow::TestWindow(QWidget * parent):QWidget(parent)
{
    // Setting window title
    setWindowTitle(QApplication::tr("VkTransport test window","VkTransport test window"));

    // Making textfields and labels
    loginLabel = new QLabel(QApplication::tr("Login:"));
    passwordLabel = new QLabel(QApplication::tr("Password:"));
    autoupdateLabel = new QLabel(QApplication::tr("Autoupdate:"));
    activityLabel = new QLabel(QApplication::tr("Activity:"));
    proxyHostLabel = new QLabel(QApplication::tr("Proxy Host:"));
    proxyPortLabel = new QLabel(QApplication::tr("Proxy Port:"));
    //recipientIdLabel = new QLabel(QApplication::tr("Recipient ID"));
    //messageLabel = new QLabel(QApplication::tr("Message text:"));


    loginLine = new QLineEdit(QApplication::tr(""));
    passwordLine = new QLineEdit(QApplication::tr(""));
    autoupdateLine= new QLineEdit(QApplication::tr(""));
    activityLine = new QLineEdit(QApplication::tr(""));
    proxyHostLine = new QLineEdit(QApplication::tr(""));
    proxyPortLine = new QLineEdit(QApplication::tr(""));
    recipientIdEdit = new QLineEdit(QApplication::tr(""));
    messageIdEdit = new QLineEdit(QApplication::tr(""));
    //messageText = new QTextEdit("");

    //inputTextfield = new QTextEdit("")
    outputTextfield = new QTextEdit("");

    // Making buttons
    initButton = new QPushButton(QApplication::tr("vkInit","vkInit"));
    setSettingsButton = new QPushButton(QApplication::tr("vkSetSettings","vkSetSettings"));
    getSettingsButton = new QPushButton(QApplication::tr("vkGetSettings","vkGetSettings"));
    getSendButton = new QPushButton(QApplication::tr("vkGetSend","vkGetSend"));
    getInboxButton = new QPushButton(QApplication::tr("vkGetInbox","vkGetInbox"));
    sendMessageButton = new QPushButton(QApplication::tr("vkSendMessage","vkSendMessage"));
    deleteMessageButton = new QPushButton(QApplication::tr("vkDeleteMessage","vkDeleteMessage"));
    getNewInboxButton = new QPushButton(QApplication::tr("vkGetNewInbox","vkGetNewInbox"));
    getProfileButton = new QPushButton(QApplication::tr("vkGetProfile","vkGetProfile"));
    exitButton = new QPushButton(QApplication::tr("Exit","Exit"));

    QObject::connect(initButton, SIGNAL(clicked()), this, SLOT(init()));
    QObject::connect(setSettingsButton, SIGNAL(clicked()), this, SLOT(setSettings()));
    QObject::connect(getSettingsButton, SIGNAL(clicked()), this, SLOT(getSettings()));
    QObject::connect(getSendButton, SIGNAL(clicked()), this, SLOT(getSend()));
    QObject::connect(getInboxButton, SIGNAL(clicked()), this, SLOT(getInbox()));
    QObject::connect(sendMessageButton, SIGNAL(clicked()), this, SLOT(sendMessage()));
    QObject::connect(deleteMessageButton, SIGNAL(clicked()), this, SLOT(deleteMessage()));
    QObject::connect(getNewInboxButton, SIGNAL(clicked()), this, SLOT(getNewInbox()));
    QObject::connect(exitButton, SIGNAL(clicked()), this, SLOT(close()));
    QObject::connect(getProfileButton, SIGNAL(clicked()), this, SLOT(getProfile()));


    // Making layouts
    buttonLayout = new QVBoxLayout();
    fieldsLayout = new QVBoxLayout();
    textLayout = new QVBoxLayout();
    mainLayout = new QHBoxLayout();

    fieldsLayout->addWidget(loginLabel);
    fieldsLayout->addWidget(loginLine);
    fieldsLayout->addWidget(passwordLabel);
    fieldsLayout->addWidget(passwordLine);
    fieldsLayout->addWidget(autoupdateLabel);
    fieldsLayout->addWidget(autoupdateLine);
    fieldsLayout->addWidget(activityLabel);
    fieldsLayout->addWidget(activityLine);
    fieldsLayout->addWidget(proxyHostLabel);
    fieldsLayout->addWidget(proxyHostLine);
    fieldsLayout->addWidget(proxyPortLabel);
    fieldsLayout->addWidget(proxyPortLine);
    //fieldsLayout->addWidget(recipientIdLabel);
    //fieldsLayout->addWidget(recipientIdLine);
    //fieldsLayout->addWidget(messageLabel);
    //fieldsLayout->addWidget(messageText);

    buttonLayout->addWidget(initButton);
    buttonLayout->addWidget(setSettingsButton);
    buttonLayout->addWidget(getSettingsButton);
    buttonLayout->addWidget(getSendButton);
    buttonLayout->addWidget(getInboxButton);
    buttonLayout->addWidget(sendMessageButton);
    buttonLayout->addWidget(deleteMessageButton);
    buttonLayout->addWidget(getNewInboxButton);
    buttonLayout->addWidget(getProfileButton);
    buttonLayout->addWidget(exitButton);

    //textLayout->addWidget(inputTextfield);
    textLayout->addWidget(new QLabel(QApplication::tr("Recipient:")));
    textLayout->addWidget(recipientIdEdit);
    textLayout->addWidget(new QLabel(QApplication::tr("Message:")));
    textLayout->addWidget(outputTextfield);
    textLayout->addWidget(new QLabel(QApplication::tr("Message id:")));
    textLayout->addWidget(messageIdEdit);


    mainLayout->addLayout(fieldsLayout);
    mainLayout->addLayout(textLayout);
    mainLayout->addLayout(buttonLayout);
    setLayout(mainLayout);
}

// Destructor
TestWindow::~TestWindow()        
{
}
