#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QMessageBox>
#include <QTextCodec>
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    sm = new QLabel(this);
    sm->setText("Starting Program");
    ui->statusBar->addWidget(sm);
    nam = new QNetworkAccessManager(this);
    myscene = new QGraphicsScene();
    const QByteArray dataJpeg =  "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";
    mypix = new QPixmap();
    mypix->loadFromData(QByteArray::fromBase64(dataJpeg));

    myscene->addPixmap(*mypix);
    fcsid=new QString("0");
    sid=new QString("0");
    fccode=new QString("0");
    tasks = new QBuffer();
    tasks->open(QBuffer::ReadWrite | QBuffer::Unbuffered);
    connect(tasks, SIGNAL(readyRead()), SLOT(processTasks()));



    ui->captchaView->setMinimumSize(mypix->width()+2,mypix->height()+2);
    ui->captchaView->setMaximumSize(mypix->width()+2,mypix->height()+2);
    ui->captchaView->setFocusPolicy(Qt::NoFocus);
    ui->captchaView->setDragMode(QGraphicsView::NoDrag);
    ui->captchaView->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->captchaView->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->captchTextEdit->setDisabled(true);
    ui->setCaptchButton->setDisabled(true);
    ui->captchaView->setScene(myscene);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_pushButton_clicked()
{


}

void MainWindow::finishedSlot(QNetworkReply* reply=NULL)
{
    if (reply==NULL)
        reply=this->reply;

    if (reply->error() == QNetworkReply::NoError || QNetworkReply::UnknownContentError==reply->error())
    {
        ui->plainTextEdit->setPlainText(QTextCodec::codecForName("utf8")->toUnicode(reply->readAll())); //best solution!
        QList<QByteArray> headlist =reply->rawHeaderList();
        QList<QNetworkCookie> cooklist =reply->manager()->cookieJar()->cookiesForUrl(reply->url());
        ui->textEdit->clear();
        ui->textEdit_2->clear();
        foreach (QNetworkCookie cook, cooklist) {
            ui->textEdit->append(QString(cook.toRawForm()));
        }
        foreach (QByteArray head, headlist) {
            ui->textEdit_2->append(QString(head) + QString(": ") + QString(reply->rawHeader(head)));
        }
    }
    // Some http error received
    else
    {
        if (QNetworkReply::UnknownContentError!=reply->error())

            ui->plainTextEdit->setPlainText("Some problems");
    }
}

void MainWindow::readyReadAuthReply()
{
    sm->setText("Getting auth reply");
}
void MainWindow::getSidFromReply()
{
    sm->setText("gettingSidFromReply");
    QVariant vsid = reply->header(QNetworkRequest::LocationHeader);
    if (!vsid.isValid())
    {
        sm->setText("We have not Location");
        return;
    }

    QString qsid = vsid.toString();
    int lifsid = qsid.lastIndexOf("sid=");
    if (lifsid < 0) {
        sm->setText("sid= not found");
        return;
    }
    delete sid;
    sid = new QString(qsid.mid(lifsid+4));
    if ((*sid)[0]==QChar('-')) {
        switch ((*sid)[1].toLatin1()) {
        case '1':
            QMessageBox::information( this, "Sid problen","-1" );
            break;
        case '2':
            QMessageBox::information( this, "Sid problen","-2" );
            on_getCaptchButton_clicked();
            break;
        case '3':
            QMessageBox::information( this, "Sid problen","-3" );
            break;
        case '4':
            QMessageBox::information( this, "Sid problen","-4" );
            break;
        default:
            QMessageBox::information( this, "Sid problen","wa" );
            break;
        }
    }
    ui->sidLineEdit->setText(*sid);

    QString qmid =  QString(reply->rawHeader("Set-Cookie"));
    QRegExp rxmid("remixmid=(\\d+);");
    if (rxmid.indexIn(qmid) < 0) {
        sm->setText("remixmid not found");
        return;
    }
    remixmid = new QString(rxmid.cap(1));
    ui->remixmidEdit->setText(*remixmid);
}
void MainWindow::finishedReadReply()
{
    ui->passwordLineEdit->setText("finishedReadReply");
finishedSlot(reply);
}
void MainWindow::replyError(QNetworkReply::NetworkError error)
{
    if (QNetworkReply::UnknownContentError==error)
    QMessageBox::information(this, "Empty request", QString("It normal! Request was empty"));
    else
    QMessageBox::information(this, "Network errors", QString("Error #")+QString::number(error));

}



void MainWindow::on_getLinkButton_clicked()
{

    QString reqlink = ui->linkLineEdit->text();
    if (!reqlink.isEmpty()) {
        QUrl url(reqlink);
        for (int i=ui->countRequestsEdit->text().toInt(); i>0; i--) {
            reply = nam->get(QNetworkRequest(url));
            connect(reply, SIGNAL(finished()), SLOT(finishedReadReply()));
            connect(reply, SIGNAL(error(QNetworkReply::NetworkError)),
                    SLOT(replyError(QNetworkReply::NetworkError)));
        }
    } else
    ui->plainTextEdit->setPlainText("Set request link");


}

void MainWindow::on_getSidButton_clicked()
{
    if (ui->loginLineEdit->text().isEmpty() || ui->passwordLineEdit->text().isEmpty()) {
        sm->setText("Incorrect user data");
        return;
    }
    QUrl url(QString("http://login.userapi.com/auth?site=2&login=force&email=")
            +ui->loginLineEdit->text()+QString("&pass=")+ui->passwordLineEdit->text());
    QNetworkRequest need(url);
    reply =
    nam->get(need);
    connect(reply, SIGNAL(finished()), SLOT(getSidFromReply()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)),
            SLOT(replyError(QNetworkReply::NetworkError)));

}

void MainWindow::on_setProxyButton_clicked()
{
    proxy = new QNetworkProxy(QNetworkProxy::HttpProxy,ui->proxyHostEdit->text(),ui->proxyPortEdit->text().toInt());
    QNetworkProxy::setApplicationProxy(*proxy);
}

void MainWindow::on_getCaptchButton_clicked()
{
    QMessageBox::information( this, "Auth String","need captch?" );
    QDateTime now = QDateTime::currentDateTime();
    delete fcsid;
    fcsid = new QString(QString::number(1031415926.0/now.toTime_t(),'f',15));
    QUrl url(QString("http://userapi.com/data?act=captcha&csid=")+(*fcsid));
    QNetworkRequest need(url);

    reply = nam->get(need);
    connect(reply, SIGNAL(finished()), SLOT(getCaptchFromReply()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)),
            SLOT(replyError(QNetworkReply::NetworkError)));
    ui->captchTextEdit->setDisabled(false);
    ui->setCaptchButton->setDisabled(false);
}


void MainWindow::getCaptchFromReply()
{

    //   no error received?
    if (reply->error() == QNetworkReply::NoError)
    {
    myscene->clear();
    if (mypix->loadFromData(reply->readAll()))
        sm->setText("We loadFromData succsess ");
    else
        sm->setText("We loadFromData fail ");

    myscene->addPixmap(*mypix);
    QList<QByteArray> headlist =reply->rawHeaderList();
    QList<QNetworkCookie> cooklist =reply->manager()->cookieJar()->cookiesForUrl(reply->url());
    ui->textEdit->clear();
    ui->textEdit_2->clear();
    foreach (QNetworkCookie cook, cooklist) {
        ui->textEdit->append(QString(cook.toRawForm()));
    }
    foreach (QByteArray head, headlist) {
        ui->textEdit_2->append(QString(head) + QString(": ") + QString(reply->rawHeader(head)));
    }
    }
    // Some http error received
    else
    {
            sm->setText("Some problems with retrieving captch");
    }
}

void MainWindow::on_setCaptchButton_clicked()
{
    delete fccode;
    fccode = new QString(ui->captchTextEdit->text());
    myscene->clear();
    mypix->load("data.jpeg");
    myscene->addPixmap(*mypix);
    ui->captchTextEdit->setDisabled(true);
    ui->setCaptchButton->setDisabled(true);
}
void MainWindow::processTasks() {
    QByteArray rl = tasks->read(2);
    QMessageBox::information( this, "Auth String",QString(rl) );
}

void MainWindow::on_senMessageButton_clicked()
{
}
