/*******************************************************************************
**
** Example of decoding of base64 image. Only in one file.
** In future will be using paintEvent instead QGraphicsView.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#include <QApplication>
#include <QDialog>
#include <QHBoxLayout>
#include <QPushButton>
#include <QPixmap>
#include <QLineEdit>
#include <QLabel>

int main(int argc, char **argv) {
    QApplication app(argc, argv);
    QDialog *w = new QDialog();

    // Текст запроса можно поместить прямо в заголовок.
    w->setWindowTitle(app.tr("Enter text from image"));

    // Все кнопки буду выровнены по горизонтали.
    QHBoxLayout hbl(w);
    w->setLayout(&hbl);

    // Pixmap в который будет закружено декодированное изображение
    QPixmap *cp = new QPixmap();

    // Создаём label, в котором будет нарисована капча
    QLabel *ql = new QLabel(w);
    hbl.addWidget(ql);

    // Поле для ввода кода с картинки
    QLineEdit *le = new QLineEdit(w);
    hbl.addWidget(le);

    // Кнопочка отправки сообщения.
    QPushButton *pb = new QPushButton(app.tr("Send"),w);
    hbl.addWidget(pb);

    // Для примера, просто закрываем диалог.
    w->connect(pb,SIGNAL(clicked()),w,SLOT(close()));

    // Предполагаемая строка, которая будет получена от первого приложения.
    QByteArray c_text = "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";

    // Загружаем картинку из кодированной строки
    cp->loadFromData(QByteArray::fromBase64(c_text));

    // Маленькая перестраховка с размером label
    ql->setMinimumSize(cp->size());
    //ql->setMaximumSize(cp->size());

    // Для красоты, делаем все элементы Высотой не меньше, чем капча
    pb->setMinimumHeight(cp->height()); /*pb->setMinimumSize(cp->size());*/
    le->setMinimumHeight(cp->height()); /*le->setMinimumSize(cp->size());*/

    // Устанавливаем изображение на label
    ql->setPixmap(*cp);

    w->show();
    return app.exec();

}
