/*******************************************************************************
**
** vksettingssink.cpp - implement VkSettingsSink, gui configurator
**                      of settings for sink function of Vkontakte service.
**                      Inherited by QMailMessageServiceEditor.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#include "vksettingssink.h"
#include "vkconfiguration.h"
#include <QLineEdit>
#include <QMessageBox>
#include <qmailaccount.h>
#include <qmailaccountconfiguration.h>
#include <qmailtransport.h>


namespace {
    const QString serviceKey("vk");
}


VkSettingsSink::VkSettingsSink()
    : QMailMessageServiceEditor(),
      warningEmitted(false)
{
    setupUi(this);
    setLayoutDirection(qApp->layoutDirection());
}

void VkSettingsSink::displayConfiguration(const QMailAccount &account,
                                      const QMailAccountConfiguration &config)
{
    VkConfiguration vkConfig(config);
    if (vkConfig.captchaState()) {
        captchaBox->setHidden(false);
        const QByteArray captcha = vkConfig.captchaImg();
        if (!captcha.isEmpty()) {
            QPixmap cp;
            if (cp.loadFromData(QByteArray::fromBase64(captcha))) {
                captchaImagelabel->setMinimumSize(cp.size());
                captchaImagelabel->setPixmap(cp);
            } else {
                captchaImagelabel->setText(tr("No Captcha"));;
            }
        } else {
            captchaImagelabel->setText(tr("No Captcha"));;
        }
        captchaCodeEdit->setText("");
    } else {
        captchaBox->setHidden(true);
    }
    Q_UNUSED(account);
}

bool VkSettingsSink::updateAccount(QMailAccount *account,
                               QMailAccountConfiguration *config)
{
    if (!config->services().contains(serviceKey))
        config->addServiceConfiguration(serviceKey);

    VkConfigurationEditor vkConfig(config);
    vkConfig.setType(QMailServiceConfiguration::SourceAndSink);
    vkConfig.setCaptchaText(captchaCodeEdit->text().toAscii());

    //account->setFromAddress(QMailAddress("qmf user","vk@vk.com"));

    // Need Synchronization from external sources
    account->setStatus(QMailAccount::SynchronizationEnabled, true);

    // Do we have a configuration we can use?
    account->setStatus(QMailAccount::CanTransmit, true);

    return true;
}
