%define realname	qmf-facebook
Name:       libqmf-facebook0
Summary:    Facebook plugin for Qt Messaging Framework
Version:    0.1.3
Release:    1
Group:      System/Libraries
License:    GPL v2+
URL:        http://qmf-facebook.garage.maemo.org
Source0:    %{realname}_%{version}-1.tar.gz
Patch0:     01_qmf_pc_names.patch
Patch1:     02_install_path.patch
BuildRoot:  %{_tmppath}/%{name}-root

# qt
%if 0%{?suse_version}  
BuildRequires:  libqt4-devel >= 4.6.0  
Requires:       libqt4 >= 4.6.0
%endif  

%if 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  qt4-devel
BuildRequires:  gcc-c++
Requires:       qt4
%endif

%if 0%{?mdkversion}
BuildRequires:  qt4-devel
BuildRequires:  gcc-c++
Requires:       qt4-common
%endif

%if 0%{?fedora_version}
BuildRequires:  qt4-devel
BuildRequires:  gcc-c++
Requires:       qt4
%endif

%if "0%{?meego_version}" != "0"
BuildRequires:  libqt-devel
Requires:       qt
%endif

BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(mysocials-dev)

# libfacebook
Requires:       libmsafb0

# qmf
%if "0%{?meego_version}" != "0"
BuildRequires:  qmf-devel
Requires:       libmessageserver1
%else
BuildRequires:  messagingframework-devel
Requires:       messagingframework
%endif

%description
Plugin for Qt Messaging Framework Library and Messaging Server

%prep
%setup -q -n %{realname}-%{version}

%if "0%{?meego_version}" != "0"
# 01_qmf_pc_names.patch
%patch0 -p1
%endif

# 02_install_path.patch
%patch1 -p1

# >> setup
%define _qt4_prefix %{_libdir}/qt4
%define _qt4_plugindir %{_qt4_prefix}/plugins
# << setup

%build
# >> build pre
export PATH=$PATH:/usr/%{_libdir}/qt4/bin
unset LD_AS_NEEDED
export QMF_INSTALL_ROOT=/usr

%if "0%{?meego_version}" != "0"
%qmake QMF_INSTALL_ROOT=$QMF_INSTALL_ROOT
%else
%if 0%{?fedora_version} || 0%{?centos_version}
qmake-qt4 QMF_INSTALL_ROOT=$QMF_INSTALL_ROOT
%else
qmake QMF_INSTALL_ROOT=$QMF_INSTALL_ROOT
%endif
%endif
# << build pre

%__make %{?jobs:-j%jobs}

# >> build post
# << build post
%install
rm -rf %{buildroot}
# >> install pre

export INSTALL_ROOT=%{buildroot}

# << install pre
%if "0%{?meego_version}" != "0"
%qmake_install
%else
%if 0%{?mdkversion} || 0%{?fedora_version} < 13
make install
%else
# >> install post
%make_install
# << install post
%endif
%endif
libdir=%_libdir

# for x86 lib dir will lib64:
%ifarch x86_64
mv %buildroot/%_prefix/lib %buildroot/%_libdir
%endif

# >> install post
# << install post

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_qt4_plugindir}/messageservices/*.so
# >> files
# << files

