#ifndef QMLMAINWINDOW_H
#define QMLMAINWINDOW_H

#include <QDeclarativeItem>
#include <QGraphicsProxyWidget>

#include "mainwindow.h"
#include "ui_mainwindow.h"

class QMLMainWindow : public QDeclarativeItem
{Q_OBJECT
 Q_PROPERTY(bool fullScreen READ fullScreen WRITE setFullScreen NOTIFY fullScreenChanged)
 Q_PROPERTY(int width READ width WRITE setWidth NOTIFY sizeChanged)
 Q_PROPERTY(int height READ height WRITE setHeight NOTIFY sizeChanged)


public:
 QMLMainWindow(QDeclarativeItem *parent =0): QDeclarativeItem(parent), window(new MainWindow())
 {
     //window->setStyleSheet(STYLE);
  //window->ui->mExit->disconnect();
  window->ui->mFullScreen->disconnect();
  connect(window->ui->mFullScreen,SIGNAL(toggled(bool)),this,SLOT(setFullScreen(bool)));
  connect(window->ui->mFullScreen,SIGNAL(toggled(bool)),this,SLOT(showMenu(bool)));
  //window->menuBar()->setVisible(0);
  proxy = new QGraphicsProxyWidget(this);
  proxy->setWidget(window);

//#if defined(Q_WS_WIN)
//  setWidth(640);
//  setHeight(480);
//#endif

  ////window->setAutoFillBackground(false);
  //window->setAttribute(Qt::WA_TranslucentBackground);

//  window->setWindowFlags(Qt::FramelessWindowHint);
//  window->ui->mExit->disconnect();
//  window->ui->mFullScreen->disconnect();
//  //window->menuBar()->setVisible(0);
//  proxy = new QGraphicsProxyWidget(this);
//  proxy->setWidget(window);
 }

 const bool &fullScreen() const { return !window->ui->mFullScreen->isChecked(); }

 const int width() const { return window->width(); }
 void setWidth(const int width)
 {
  window->resize(width,window->height());
  emit sizeChanged();
 }
 const int height() const { return window->height(); }
 void setHeight(const int height)
 {
  window->resize(window->width(),height);
  emit sizeChanged();
 }


public slots:
 void setFullScreen(const bool){ emit fullScreenChanged(); }
 void showMenu(const bool &IsHide){ window->menuBar()->setVisible(!IsHide); }

signals:
 void fullScreenChanged();
 void sizeChanged();


private:
 MainWindow *window;
 QGraphicsProxyWidget *proxy;
 //QDeclarativeContext *qmlWindow;

protected:
 virtual void geometryChanged(const QRectF &newGeometry, const QRectF & oldGeometry)
 {Q_UNUSED(oldGeometry)
   proxy->setGeometry(newGeometry);
 }

};

#endif // QMLMAINWINDOW_H
