#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "mapview/mapview.h"

namespace Ui {
    class MainWindow;
}

enum IniGroup{igMapView,igMain,igOther};
enum IniKey{ikStationCustomFont,ikStationFont,ikStationBack,ikStationShadow,ikSBackColor,ikSShadowColor,
            ikSUpperCase,ikSWordWrap,ikSTransparency,
            ikMShowScrollbar,ikWFullScreen,ikMShowTime,ikMShowBackground,ikMAntialiasing,ikMFastScrolling,
            ikMBackColor,ikMSimpleTransfers,ikMCleanCache,ikMLastFile,ikMCaching,ikWUiScale};

typedef QMap<IniKey,QString> IniKeyMap;
typedef QMap<IniGroup,IniKeyMap> IniSettingMap;

void applySettings(const IniSettingMap &settings);
void saveSettings(const IniSettingMap &settings);
void loadSettings();

bool removeDir(const QString &DirName);
qint64 sizeOfDir(const QString &DirName);

class TElement;
class TCompleter;
class Settings;
class TMobileUi;

class MainWindow : public QMainWindow
{Q_OBJECT
friend class TMobileUi;
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    //void showEvent(QShowEvent * event);

    QTextCodec *codePage;
    TMapView *map;
    Settings *SettingsWindow;

    struct TConfig
    {
     QString locale;
     int dockWidth;
     qreal mapZoomFactor;
     QPoint mapPosition;
     bool mapZoomFactorCheck;
     bool mapPositionCheck;
     bool mapKineticScrollCheck;
     int mapDefaultStationID;

     QFont appFont;
     qreal appUiScale;
     int appIconSize;
     bool appFullscreen;
     bool appFirstStart;

     QSize mainWindow;
     QSize settingWindow;
    };
    TConfig Config;

    char MobileVersion;
    Ui::MainWindow *ui;
    TMobileUi *mUi;

protected:
    bool eventFilter(QObject *obj, QEvent *event);

private:
    void closeEvent(QCloseEvent * e);

    TCompleter *Completer;

public slots:
    void setScaleForUi(qreal UiScale);
    void setScaleForUi(int UiScale) { setScaleForUi((qreal)(UiScale/100.0)); }
    void toggleLang(QString locale="");
    void setNodeDefault(bool checked,TMapNode *Node=NULL);
    void loadNodeDefault();
    void checkNodeDefault();
    void toFullScreen();
    void showPageLoading();
    void showPageMap();

private slots:

    void on_mFullScreen_toggled(bool checked);
    void on_mAddMap_triggered();
    void on_mPreference_triggered();
    void on_bClear_clicked();
    void on_mAbout_triggered();
    void on_mFind_toggled(bool checked);
    void on_eSearch_returnPressed();
    void on_mTest_triggered();
    void on_mSave_triggered();
    void on_mOpen_triggered();
    void on_mExit_triggered();
    void setDelayNames(QStringList list);
    void nodeInformation();
};

#endif // MAINWINDOW_H
