#include <QDebug>
#include <QtGui>
#include "mobileui.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "flickcharm.h"

extern MainWindow *mainWnd;
extern QString TOOLBAR_STYLE;
//extern TMapView *map;

TMobileUi::TMobileUi(QWidget *parent,TMapView *map,int type) : MapView(map)
{Q_UNUSED(parent);
 int Spacing=mainWnd->Config.appIconSize/4;
 DefaultIconSize=QSize(mainWnd->Config.appIconSize,mainWnd->Config.appIconSize);

 lTop =new QHBoxLayout;
 lBottom =new QHBoxLayout;
 lLeft =new QVBoxLayout;
 lRight =new QVBoxLayout;
 lToolbar =new QGridLayout;
 bZoomOut = new QToolButton(this);
 bZoomIn = new QToolButton(this);
 bFit = new QToolButton(this);
 bSave = new QToolButton(this);
 bZoomOut->setIcon(QIcon(":/img/zoom-out.png"));
 bZoomIn->setIcon(QIcon(":/img/zoom-in.png"));
 bFit->setIcon(QIcon(":/img/zoom-fit-best.png"));
 bSave->setIcon(QIcon(":/img/document-save.png"));
 bZoomOut->setAutoRepeat(1);
 bZoomIn->setAutoRepeat(1);
 bZoomOut->setShortcut(QKeySequence::ZoomOut);
 bZoomIn->setShortcut(QKeySequence::ZoomIn);
 connect(bSave,SIGNAL(clicked()),map,SLOT(saveToFile()));
 connect(bZoomOut,SIGNAL(clicked()),map,SLOT(zoomOut()));
 connect(bZoomIn,SIGNAL(clicked()),map,SLOT(zoomIn()));
 connect(bFit,SIGNAL(clicked()),map,SLOT(fitMap()));
 bSave->setVisible(mainWnd->ui->mSave->isVisible());

 if(!type) // MobileVersion UI
 {
  Ui::MainWindow *ui=mainWnd->ui;

  lTop->addWidget(createButtonFromAction(ui->mFind));
  lTop->addSpacing(Spacing);
  ui->eSearch->setVisible(0);
  //ui->eSearch->setMaximumWidth(maximumWidth());
  lTop->addWidget(ui->eSearch);
  lTop->addStretch();
  bExit=createButtonFromAction(ui->mExit);
  lTop->addWidget(bExit);
  bExit->setVisible(mainWnd->Config.appFullscreen);

  lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomOut);
  lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomIn);
  lLeft->addStretch();
  bClear=createButtonFromAction(ui->mClear);
  lRight->addWidget(bClear);
  bClear->setVisible(0);

  bInfo=createButtonFromAction(new QAction(QIcon(":/img/dialog-information.png"),tr("Information"),this));
  bInfo->setVisible(0);

  textInfo = new QLabel("");
  QFont TempFont=qApp->font();
  TempFont.setPixelSize(TempFont.pixelSize()/1.5);
  textInfo->setFont(TempFont);
  textInfo->setMinimumWidth(0);
  textInfo->setMinimumHeight(0);
  //textDescription->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
  textInfo->setAlignment(Qt::AlignCenter);
  textInfo->setVisible(0);
  textInfo->installEventFilter(this);

  lBottom->addWidget(bFit);
  lBottom->addSpacing(Spacing);
  lBottom->addStretch();
  lBottom->addWidget(bInfo);
  lBottom->addWidget(textInfo);
  lBottom->addStretch();
  lBottom->addSpacing(Spacing);
  bFullscreen=createButtonFromAction(ui->mFullScreen);
  lBottom->addWidget(bFullscreen);


  //### Description ###
  Description = new QWidget(this);
//  QPalette pal = palette();
//  pal.setBrush(QPalette::Window, palette().color(QPalette::Window)); // fix white background
//  Description->setPalette(pal);
//  Description->setWindowFlags(windowFlags() & (~Qt::WindowContextHelpButtonHint));
  LabelInfo = new QLabel(Description);
  LabelInfo->setAlignment(Qt::AlignHCenter);
//  LabelInfo->setStyleSheet("font-weight:bold;");
  TextDesc= new QTextBrowser(Description);
  TempFont=qApp->font();
  TempFont.setPixelSize(TempFont.pixelSize()/1.2);
  TextDesc->setFont(TempFont);
  TextDesc->setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
  TextDesc->setReadOnly(1);
  TextDesc->setFrameShape(QFrame::NoFrame);
  //bbDialog= new QDialogButtonBox(QDialogButtonBox::Close,Qt::Horizontal,Description);
  bOK= new QPushButton(tr("OK"));
  QVBoxLayout *lDescription =new QVBoxLayout(Description);
  lDescription->addWidget(LabelInfo);
  lDescription->addWidget(TextDesc);
  lDescription->addWidget(bOK);
  Description->setLayout(lDescription);
  ui->stackMain->addWidget(Description);


#if defined(Q_WS_MAEMO_5)
//  Description->setAttribute(Qt::WA_Maemo5StackedWindow);
//  Description->setWindowFlags(Qt::Window);
//  Description->setAttribute(Qt::WA_Maemo5AutoOrientation);

  //  bZoomIn->setShortcut(QKeySequence(Qt::Key_F7));
  //  bZoomOut->setShortcut(QKeySequence(Qt::Key_F8));
  QIcon icoFullScreen=QIcon::fromTheme(QLatin1String("general_fullsize"));
  if(!icoFullScreen.isNull()) ui->mFullScreen->setIcon(icoFullScreen);
  QIcon icoClose=QIcon::fromTheme(QLatin1String("general_close"));
  if(!icoClose.isNull()) ui->mExit->setIcon(icoClose);
  ui->textDescription->setTextInteractionFlags(Qt::TextSelectableByKeyboard);
#else
 FlickCharm *fcharm = new FlickCharm(TextDesc);
 fcharm->activateOn(TextDesc);
#endif

  // Description
  connect(map,SIGNAL(trackInfo(QString)),LabelInfo,SLOT(setText(QString)));
  connect(map,SIGNAL(trackDescription(QString)),TextDesc,SLOT(setText(QString)));
  connect(bOK,SIGNAL(clicked()),mainWnd,SLOT(showPageMap()));

//  connect(bOK,SIGNAL(clicked()),mainWnd,SLOT(toFullScreen()));
//  connect(bOK,SIGNAL(clicked()),Description,SLOT(close()));
//  connect(bbDialog,SIGNAL(rejected()),mainWnd,SLOT(toFullScreen()));
//  connect(bbDialog,SIGNAL(rejected()),Description,SLOT(close()));

  // UI
  connect(map,SIGNAL(nodeHasInfo(bool)),bInfo,SLOT(setVisible(bool)));
  connect(bInfo,SIGNAL(clicked()),mainWnd,SLOT(nodeInformation()));
  connect(map,SIGNAL(trackFinded(bool)),textInfo,SLOT(setVisible(bool)));
  connect(map,SIGNAL(trackInfo(QString)),textInfo,SLOT(setText(QString)));
  connect(bFullscreen,SIGNAL(toggled(bool)),bExit,SLOT(setVisible(bool)));
  connect(ui->mFind,SIGNAL(toggled(bool)),map->scene,SLOT(update()));
  connect(map,SIGNAL(trackFinded(bool)),this,SLOT(hideSearch(bool)));
  connect(map,SIGNAL(nodeClicked(bool)),bClear,SLOT(setVisible(bool)));

 }
 if(type) // Details window
 {
  lTop->addWidget(bZoomOut);
  lTop->addStretch();
  lTop->addWidget(bSave);

  //lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomIn);
  lLeft->addStretch();

  lBottom->addWidget(bFit);
  lBottom->addStretch();
 }

 lToolbar->setMargin(2);
 lToolbar->addItem(lTop,0,0,1,3);
 lToolbar->addItem(lLeft,1,0);
 lToolbar->addItem(lRight,1,2);
 lToolbar->addItem(lBottom,2,0,1,3);
 map->setLayout(lToolbar);
 setToolbarIconSize(mainWnd->Config.appIconSize);

}
TMobileUi::~TMobileUi()
{

}

QToolButton* TMobileUi::createButtonFromAction(QAction *Action,bool AutoRepeat)
{
 QToolButton *button=new QToolButton(this);
 button->setDefaultAction(Action);
 button->setIconSize(DefaultIconSize);
 button->setAutoRepeat(AutoRepeat);
 return button;
}

void TMobileUi::setToolbarIconSize(int Size)
{
 if(!bZoomOut) return;
 QSize IconSize=QSize(Size,Size);
 MapView->setStyleSheet(TOOLBAR_STYLE.arg(Size)          // 1
                                     .arg(int(Size/2))   // 2
                                     .arg(int(Size/4))   // 3
                                     .arg(int(Size/6))   // 4
                                     .arg(int(Size/8))   // 5
                                     .arg(int(Size/10))  // 6
                                     .arg(int(Size/12)));// 7
 QList<QToolButton *> buttons =  MapView->findChildren<QToolButton *>();
 foreach(QToolButton *b,buttons)
 {
  b->setIconSize(IconSize);
 }
}

void TMobileUi::hideSearch(bool state)
{
 if(state) mainWnd->ui->mFind->setChecked(0);
}

bool TMobileUi::eventFilter(QObject *obj, QEvent *event)
{
 if(obj==textInfo && event->type() == QEvent::MouseButtonPress)
 {
//  mainWnd->ui->mFullScreen->setChecked(0);
  LabelInfo->setText("<b>"+LabelInfo->text()+"</b>");
  LabelInfo->update();
  textInfo->update();
//  Description->showFullScreen();
  mainWnd->ui->stackMain->setCurrentIndex(2);
  return true;
 }
 else return QObject::eventFilter(obj, event);

}
