#include <QDebug>
#include <QSettings>
#include <QFileDialog>
#include <QKeyEvent>
#include <QMessageBox>

#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QDir>

#include "ui_mainwindow.h"
#include "mainwindow.h"
#include "ui_settings.h"
#include "settings.h"
#include "ui_details.h"
#include "details.h"
#include "about.h"

#include "mapview/mapview.h"
#include "mapview/maplayer.h"
#include "mapview/maproute.h"
#include "mapview/mapnode.h"
#include "completer.h"
#include "mobileui.h"
#include "flickcharm.h"

QString VERSION=" 0.5.2";
QString URL_MAPS="http://pmetro.su/Maps.html";
QString URL_TRANSLATE="http://translate.google.com/translate?sl=ru&tl=%1&u=%2";

char ICONSIZE=24; // begin size 100% scale
QString TOOLBAR_STYLE=
  "QToolButton,QToolButton:pressed,QLabel,QLineEdit{border:2px solid grey;border-radius:5px;background-color:qlineargradient(x1:0,y1:0,x2:0,y2:1,stop:0 #dadbde,stop:1 rgba(255,255,255,60%));} "
  "QToolButton{height:%1px;width:%1px;background-color:transparent;margin-top:4px;margin-left:4px;} "
  "QToolButton:pressed{margin-top:5px;margin-left:5px;} "
  "QLabel{color:black;font-weight:bold;padding:2px;} "
  "QLineEdit{height:%1px;font-weight:bold;margin-top:2px;margin-left:2px;}";

MainWindow *mainWnd;

FlickCharm charm;

IniSettingMap AppConfig;

QString appPath, appConfigFile, cachePath;

QTranslator appTranslator;

extern QTime testTimer;

QVector <QString> IniGroupStr;
QVector <QString> IniKeyStr;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),map(NULL),SettingWindow(NULL),ui(new Ui::MainWindow),Completer(NULL)
{
#if defined(Q_OS_WINCE) || defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5) || defined(Q_OS_ANDROID)
 MobileVersion=1;
#else
 MobileVersion=0;
#endif

 //MobileVersion=1;
 codePage = QTextCodec::codecForName("windows-1251");
 mainWnd=this;
 IniGroupStr << "MapView"<<"Main"<<"Other";
 IniKeyStr << "StationCustomFont"<<"StationFont"<<"StationBack"<<"StationShadow"<<"StationBackColor"<<"StationShadowColor"<<
              "StationUpperCase"<<"StationWordWrap"<<"StationTransparency"<<
              "MapShowScrollbar"<<"WindowFullScreen"<<"MapShowTime"<<"MapShowBackground"<<"MapAntialiasing"<<"MapFastScrolling"<<
              "MapBackColor"<<"MapSimpleTransfers"<<"MapCleanCache"<<"MapLastFile"<<"MapCaching"<<"UiScale";


 Config.appFont=qApp->font();
 appPath=qApp->applicationDirPath()+"/";
 appConfigFile=cachePath="";
#ifdef Q_OS_LINUX
 QString home=qgetenv("HOME");
 appPath="/usr/share/qmetro/";
 if(!home.isEmpty())
 {
  cachePath=home+"/.cache/qMetro/";
  appConfigFile=home+"/.config/qMetro/config.conf";
 }
#endif
#ifdef Q_WS_MAEMO_5
 setAttribute(Qt::WA_Maemo5AutoOrientation);
 setAttribute(Qt::WA_Maemo5StackedWindow);
 setAttribute(Qt::WA_Maemo5NonComposited);
 appPath="/home/user/MyDocs/Data/qMetro/";
 cachePath=appPath+".cache/";
 appConfigFile="/home/user/.config/qMetro/config.conf";
 ICONSIZE=64;
#endif
#ifdef Q_OS_ANDROID
 appPath="/sdcard/Android/data/qMetro/";
 cachePath=appPath+".cache/";
 setScaleForUi(2.6);
#endif
#ifdef Q_OS_SYMBIAN
 appPath="e:/Data/qMetro/";
 ICONSIZE=48;
#endif

 if(appConfigFile.isEmpty()) appConfigFile=appPath+"config.ini";
 if(cachePath.isEmpty()) cachePath=appPath+"cache/";
 Config.appIconSize=ICONSIZE;

 QSettings *ini=new QSettings(appConfigFile,QSettings::IniFormat);
 ini->setIniCodec(codePage);
 QString key;
 ini->beginGroup("Main");
 Config.locale=ini->value("Locale","").toString();
 Config.dockWidth=ini->value("DockWidth",0).toInt();
 key="WindowFullScreen";
 Config.appFullscreen=ini->value(key,0).toBool();
 key="MapZoomFactor";
 Config.mapZoomFactor=ini->value(key).toFloat();
 Config.mapZoomFactorCheck=ini->contains(key);
 key="MapPosition";
 Config.mapPosition=ini->value(key).toPoint();
 Config.mapPositionCheck=ini->contains(key);
 key="Mobile";
 if(ini->contains(key)) MobileVersion=ini->value(key).toInt();
 key="Font";
 if(ini->contains(key))
 {
  Config.appFont.fromString(ini->value(key).toString());
  qApp->setFont(Config.appFont);
 }
 TOOLBAR_STYLE=ini->value("Styles",TOOLBAR_STYLE).toString();
 if(Config.locale.isEmpty()) Config.locale=QLocale::system().name().section("_",0,0);
 toggleLang(Config.locale);
 ui->setupUi(this); // UI #############################
 restoreState(QByteArray::fromHex(ini->value("WindowState").toByteArray()));
 if(!MobileVersion)
 {
  key="WindowGeometry";
  if(ini->contains(key))
  {
   restoreGeometry(QByteArray::fromHex(ini->value(key).toByteArray()));
   if(windowState()==Qt::WindowFullScreen) setWindowState(Qt::WindowMaximized);
  }
  else
  {
   resize(640,480);
   setWindowState(Qt::WindowMaximized);
  }
 }
 ui->mSaveScale->setChecked(Config.mapZoomFactorCheck);
 ui->mSavePosition->setChecked(Config.mapPositionCheck);
 if(!Config.dockWidth) Config.dockWidth=ui->dock->width();
 ui->dock->setVisible(0);
 //ui->eSearch->setText(tr("Find"));
 //ui->eSearch->installEventFilter(this);
 ini->endGroup();

 setWindowTitle(windowTitle()+VERSION);

 map = new TMapView(appPath,cachePath);
 map->config.MobileVersion=MobileVersion;
 map->config.locale=Config.locale;

 connect(map,SIGNAL(trackText(QString)),ui->textDescription,SLOT(setText(QString)));
 if(!MobileVersion)
   connect(map,SIGNAL(trackFinded(bool)),ui->mFind,SLOT(setChecked(bool)));
 connect(map,SIGNAL(delayNames(QStringList)),this,SLOT(setDelayNames(QStringList)));

 //map->config.enableCaching=1;
 Config.mapKineticScrollCheck=0;
 if(Config.mapKineticScrollCheck)
 {
  charm.activateOn(map);
  connect(&charm,SIGNAL(started()),map,SLOT(mapStartDragging()));
  connect(&charm,SIGNAL(finished()),map,SLOT(mapStopDragging()));
 }


 ui->toolBar->setIconSize(QSize(Config.appIconSize,Config.appIconSize));

 if(!MobileVersion)
 {
  QHBoxLayout *EditLayout = new QHBoxLayout;
  ui->bClear->setCursor(Qt::ArrowCursor);
  ui->bClear->setStyleSheet("QToolButton{border:0px;background-color:transparent;}");
  EditLayout->setAlignment(Qt::AlignRight);
  EditLayout->setMargin(3);
  EditLayout->addWidget(ui->bClear);
  ui->eSearch->setLayout(EditLayout);

  QSplitter *splitter = new QSplitter;
  splitter->addWidget(ui->dock);
//  QLabel *LoadingLabel =new QLabel(this);
//  QMovie *LoadingMovie =new QMovie(":/img/loading.gif");
//  LoadingLabel->setAlignment(Qt::AlignCenter);
//  LoadingLabel->setMovie(LoadingMovie);
//  LoadingMovie->start();
  splitter->addWidget(map);
  splitter->setStretchFactor(0, 0);
  splitter->setStretchFactor(1, 1);
  splitter->setChildrenCollapsible(0);
  splitter->setOpaqueResize(0);
  setCentralWidget(splitter);

  QLabel *label = new QLabel("");
  label->setMinimumWidth(0);
  label->setMinimumHeight(0);
  label->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
  ui->toolBar->addWidget(label);
  ui->toolBar->addAction(ui->mPreference);

 }else
 {
  setFixedWidth(qApp->desktop()->width());
  setFixedHeight(qApp->desktop()->height());
  centralWidget()->layout()->addWidget(map);
  mUi = new TMobileUi(this,map);
  //setCentralWidget(map);
 }

#ifdef Q_OS_LINUX
 ui->menuHelp->setIcon(QIcon());
#endif
#ifdef Q_OS_SYMBIAN
 // Remove context menu from all widgets
 QWidgetList widgets=QApplication::allWidgets();
 QWidget* w=0;
 foreach(w,widgets) w->setContextMenuPolicy(Qt::NoContextMenu);
#endif

#ifdef QT_NO_DEBUG
 ui->menuView->menuAction()->setVisible(0);
 ui->menuInfo->menuAction()->setVisible(0);
 //ui->menuSetting->menuAction()->setVisible(0);
 //ui->menuHelp->addAction(ui->menuLanguage->menuAction());
#endif


 // apply config
 map->show();
 if(Config.appFullscreen) //AppConfig.value(igMain).value(ikWFullScreen).toInt()
      ui->mFullScreen->setChecked(1);
 else (MobileVersion ? showMaximized():show());

 //map->resize(qApp->desktop()->width(),qApp->desktop()->availableGeometry().height()-(height()-map->height())-20);
 map->resize(geometry().right()-geometry().left(),geometry().bottom()-geometry().top()-(height()-map->height()));
 loadSettings();

 if(Config.mapZoomFactorCheck) // first
 {
  map->scaleMap(Config.mapZoomFactor);
  map->centerOn(map->scene->itemsBoundingRect().center());
 }else
  map->fitMap();

 if(Config.mapPositionCheck) // second
 {
  map->horizontalScrollBar()->setValue(Config.mapPosition.x());
  map->verticalScrollBar()->setValue(Config.mapPosition.y());
 }

 connect(ui->cbDelay,SIGNAL(currentIndexChanged(int)),map,SLOT(setDelayIndex(int)));
 connect(ui->sbDelay,SIGNAL(valueChanged(int)),map,SLOT(setDelayMetro(int)));

 connect(ui->mZoomIn,SIGNAL(triggered()),map,SLOT(zoomIn()));
 connect(ui->mZoomOut,SIGNAL(triggered()),map,SLOT(zoomOut()));
 connect(ui->mFit,SIGNAL(triggered()),map,SLOT(fitMap()));

 map->nodePopup = new QMenu(this);
 map->nodePopup->addAction(new QAction(QIcon(":/img/dialog-information.png"),tr("Information"),this));
 map->nodePopup->addSeparator();
 map->nodePopup->addAction(tr("Start"));
 map->nodePopup->addAction(tr("Finish"));
 map->nodePopup->addSeparator();
 map->nodePopup->addAction(tr("Default start"));
 map->nodePopup->actions().at(5)->setCheckable(1);
 connect(map->nodePopup, SIGNAL(aboutToShow()),this, SLOT(checkNodeDefault()));
 connect(map->nodePopup->actions().at(0), SIGNAL(triggered()),this, SLOT(nodeInformation()));
 connect(map->nodePopup->actions().at(2),SIGNAL(triggered()),map,SLOT(setNodeBegin()));
 connect(map->nodePopup->actions().at(3),SIGNAL(triggered()),map,SLOT(setNodeEnd()));
 connect(map->nodePopup->actions().at(5),SIGNAL(triggered(bool)),this,SLOT(setNodeDefault(bool)));

 if(map->nodeByID.count()) Completer= new TCompleter(map,ui->eSearch);

 installEventFilter(this);

 QDir localeDir=QDir(appPath+"locale","*.lng",QDir::Name,QDir::Files);
 QStringList langNames=localeDir.entryList();

 langNames.prepend("ru.lng");
 langNames.prepend("en.lng");

 QActionGroup *langGroup = new QActionGroup(ui->menuLanguage);
 QMutableStringListIterator i(langNames);
 while (i.hasNext()) {
  i.next();
  QRegExp rx("(.+)\\.lng");
  rx.indexIn(i.value());
  QLocale locale(rx.cap(1));
  QAction *langAction = new QAction(QLocale::languageToString(locale.language()), this);
  langAction->setCheckable(true);
  if(locale.name().section("_",0,0)==Config.locale) langAction->setChecked(1);
  langAction->setData(locale.name().section("_",0,0));
  ui->menuLanguage->addAction(langAction);
  langGroup->addAction(langAction);
  connect(langAction, SIGNAL(triggered()),this, SLOT(toggleLang()));
 }
 if(MobileVersion) toggleLang(Config.locale);
 loadNodeDefault();
}

MainWindow::~MainWindow()
{
 delete ui;
}

void MainWindow::setNodeDefault(bool checked,TMapNode *Node)
{
 if(!Node) Node=map->nodeClick;
 if(!Node) return;
 //qDebug() << checked << map->params.mapName << Node->Route->DisplayName << Node->DisplayName;
 QSettings ini(appConfigFile,QSettings::IniFormat);
 ini.setIniCodec(codePage);
 QString key;
 ini.beginGroup("DefaultStation");
 if(checked)
 {
  Config.mapDefaultStationID=Node->ID;
  ini.setValue(map->params.mapName,Node->Route->DisplayName+","+Node->DisplayName);
  map->setNodeBegin(Node);
 }
 else
  ini.remove(map->params.mapName);
 ini.endGroup();
}
void MainWindow::loadNodeDefault()
{
 Config.mapDefaultStationID=-1;
 QSettings ini(appConfigFile,QSettings::IniFormat);
 ini.setIniCodec(codePage);
 QStringList DefaultStation=ini.value("DefaultStation/"+map->params.mapName).toString().split(",");
 //qDebug() << DefaultStation;
 if(DefaultStation.count()==2)
 {
  TMapNode *Node=NULL;
  TMapRoute *Route=map->layer.first()->findRoute(DefaultStation.first());
  if(Route) Node=Route->findNode(DefaultStation.last());
  if(Node)
  {
   Config.mapDefaultStationID=Node->ID;
   map->setNodeBegin(Node);
  }
 }
}
void MainWindow::checkNodeDefault()
{
 map->nodePopup->actions().at(5)->setChecked((map->nodeClick->ID==Config.mapDefaultStationID));
}

//bool MainWindow::eventFilter(QObject *obj, QEvent *ev)
//{
// if(obj==ui->eSearch && ui->eSearch->isVisible() && ev->type()==QEvent::FocusIn)
// {
//  ui->eSearch->selectAll();
//  return 1;
// }else
//  return MainWindow::eventFilter(obj,ev);
//}

//bool MainWindow::event(QEvent *e)
bool MainWindow::eventFilter(QObject *obj, QEvent *e)
{

 QMainWindow::event(e);
 switch (e->type()) {
 case QEvent::LanguageChange:
  {
   ui->retranslateUi(this);
   if(SettingWindow) SettingWindow->ui->retranslateUi(SettingWindow);
#ifdef Q_WS_MAEMO_5
   ui->mPreference->setText(ui->menuSetting->title());
#endif
   return 1;
  }
  break;
 case QEvent::Resize:
  {
   if(map->selectedNode.count()) map->selectedNodesToFront(1);
   map->mapStartDragging();
   //map->fitMap();
   return 1;
  }
  break;
 case QEvent::KeyPress:
  {
   QKeyEvent* event = (QKeyEvent*)e;
   Qt::Key key = (Qt::Key)event->key();

   if(key==Qt::Key_Escape)
   {
    //if(windowState()==Qt::WindowFullScreen)
    ui->mFullScreen->setChecked(0); //showMaximized();
    map->clearTrack();
   }
   if(key==Qt::Key_F1) on_mAbout_triggered();
   if(key==Qt::Key_F11)
   {
    ui->mFullScreen->setChecked(windowState()!=Qt::WindowFullScreen);
   }
   QString char_key=event->text().simplified();
   if(!ui->mFind->isChecked() && !char_key.isEmpty())//((key>=Qt::Key_A && key<=Qt::Key_Z)||(key>=Qt::Key_0 && key<=Qt::Key_9)) )
   {
    ui->mFind->setChecked(1);
    ui->eSearch->setText(char_key);
    ui->eSearch->setFocus();
   }
   return 1;
  }
  break;
 default: ;
 }


 if (obj == ui->eSearch && e->type()==QEvent::FocusIn)
 {
  qDebug("QEvent::FocusIn event intercepted");
  ((QLineEdit *)obj)->selectAll();
  return 0;
 }
 else
  if (obj == ui->eSearch && e->type()==QEvent::FocusOut)
  {
  qDebug("QEvent::FocusOut event intercepted");
  return 0;
 }

 return 0;
}

void MainWindow::on_mExit_triggered()
{
 close();
}

void MainWindow::on_mOpen_triggered()
{
 QFileDialog::Options options;
#ifdef Q_OS_WINCE
 options=QFileDialog::DontUseNativeDialog;
#endif
 QString MapPath=QString("%1map/").arg(appPath);

// ZIPed maps will be unpacked
 QDir Dir(MapPath);
 if (Dir.exists())
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::Files))
  {
   QRegExp regExp=QRegExp("*.zip",Qt::CaseInsensitive,QRegExp::Wildcard);
   if(info.isFile() && info.fileName().contains(regExp))
   {
    map->extractFiles(info.absoluteFilePath(),"*.pmz",MapPath);
    QFile::remove(info.absoluteFilePath());
   }
  }

 QString fileName = QFileDialog::getOpenFileName(this,
            tr("Open file"),MapPath,QString("%1 pMetro (*.pmz)").arg(tr("Map")),0,options);

 if (fileName.isEmpty()) return;

//#ifndef QT_NO_CURSOR
// QApplication::setOverrideCursor(Qt::WaitCursor);
//#endif

//testTimer.start();
 if(Completer) delete Completer;
 map->loadMap(fileName);
 map->fitMap();
 //map->viewport()->repaint();
 ui->eSearch->setText("");
 Completer= new TCompleter(map,ui->eSearch);
//qDebug() << "Load time: " << testTimer.elapsed();

//#ifndef QT_NO_CURSOR
// QApplication::restoreOverrideCursor();
//#endif
}

void MainWindow::on_mSave_triggered()
{
 map->saveToFile();
}

void MainWindow::on_mTest_triggered()
{
 qDebug() << map->horizontalScrollBar()->value();
}

void MainWindow::on_eSearch_returnPressed()
{
 ui->eSearch->selectAll();
}

void MainWindow::on_mFind_toggled(bool checked)
{
 if(!MobileVersion) // PC
 {
  map->mapStartDragging();
  if(checked)
   ui->dock->resize(QSize(Config.dockWidth,ui->dock->height()));
  else
   Config.dockWidth=ui->dock->width();
  ui->dock->setVisible(checked);
  if(checked) ui->dock->repaint();
 }
 else
 {
  //map->setUpdatesEnabled(0);
  ui->eSearch->setVisible(checked);
  //(checked ? ui->eSearch->setMaximumWidth(maximumWidth()):ui->eSearch->setFixedWidth(0));
  //map->setUpdatesEnabled(1);
 }

 ui->eSearch->setFocus();
 ui->eSearch->selectAll();
}

void MainWindow::on_bClear_clicked()
{
 map->clearTrack();
 ui->eSearch->clear();
 ui->eSearch->setFocus();
 ui->cbDelay->setCurrentIndex(0);
}

void MainWindow::setDelayNames(QStringList list)
{
 ui->cbDelay->clear();
 ui->cbDelay->addItems(list);
 ui->cbDelay->setCurrentIndex(0);
}

void MainWindow::on_mAbout_triggered()
{
 About *a=new About(this);
 //if(MobileVersion) a->showMaximized(); else
 a->exec();
}

void MainWindow::on_mPreference_triggered()
{
 if(!SettingWindow)
 {
  SettingWindow = new Settings(this);

#ifdef Q_WS_MAEMO_5
  SettingWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
  SettingWindow->setWindowFlags(Qt::Window);
  SettingWindow->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
 }

 SettingWindow->loadSettings(AppConfig);

 if(MobileVersion)
      SettingWindow->showMaximized();
 else SettingWindow->show();
}

void MainWindow::toggleLang(QString locale)
{
 QAction *action = qobject_cast<QAction *>(sender());

 qApp->removeTranslator(&appTranslator);

 if(action || locale.isEmpty()) locale=action->data().toString();

 if(locale=="ru")
      appTranslator.load("ru.qm",":/locale");
 else appTranslator.load(locale+".lng",appPath+"locale");

 qApp->installTranslator(&appTranslator);
 Config.locale=locale;
 if(map) map->config.locale=locale;
}

void infoAddTab(QWidget *widget, const QString &Caption,const QString &Text)
{
 QTextBrowser *TextEdit=new QTextBrowser();

#ifndef Q_WS_MAEMO_5
 FlickCharm *fcharm = new FlickCharm(TextEdit);
 fcharm->activateOn(TextEdit);
#endif
 TextEdit->setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
 TextEdit->setText(Text); 
 TextEdit->setReadOnly(1);
 TextEdit->setOpenExternalLinks(1);
 //TextEdit->setMinimumHeight(200);
 // FIX IT: double scroll. need something better then that
 TextEdit->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Ignored);

 if(widget->metaObject()->className()==QString("QTabWidget").toAscii())
 {
  ((QTabWidget*)widget)->addTab(TextEdit,Caption);
  if(!mainWnd->MobileVersion) TextEdit->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
 }
 else
 {
  ((QToolBox*)widget)->addItem(TextEdit,QIcon(":/img/bullet.png"),Caption);

 }

}

void MainWindow::nodeInformation()
{
 if(!map->nodeClick) return;

//testTimer.start();
 Details *DetailsWindow = new Details(this);

#ifdef Q_WS_MAEMO_5
 DetailsWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
 DetailsWindow->setWindowFlags(Qt::Window);
 DetailsWindow->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif


 DetailsWindow->setWindowTitle((MobileVersion ? "":DetailsWindow->windowTitle()+" ")+map->nodeClick->DisplayName);

 map->loadNodeInfo(map->nodeClick);

 TMapView *MapScheme;
 QVBoxLayout *layout;
 QTabWidget *Tabs=DetailsWindow->ui->tabs;
 QString AllText="";
 foreach(QString key,map->nodeClick->Info.keys())
 {
  TMapNode::InfoItem Info=map->nodeClick->Info.value(key);
  if(Info.Type==TMapNode::itImage)
  {
   QStringList Value=Info.Value.split("\n");
   foreach(QString FileName,Value)
   {
    layout = new QVBoxLayout;
    layout->setMargin(2);
    MapScheme = new TMapView(appPath,cachePath);
    MapScheme->state.mapLoaded=0;
    MapScheme->config=map->config;
    MapScheme->setAlignment(Qt::AlignCenter);
    MapScheme->params.mapColorBack=Qt::white;
    MapScheme->params.mapPath=map->params.mapPath;
    MapScheme->config.enableDrawBackground=1;
    MapScheme->config.mapLastFile="";
    MapScheme->applyConfig();

    if(MapScheme->config.enableCaching)
    {
     FlickCharm *fcharm=new FlickCharm(MapScheme);
     fcharm->activateOn(MapScheme);
     connect(fcharm,SIGNAL(started()),MapScheme,SLOT(mapStartDragging()));
     connect(fcharm,SIGNAL(finished()),MapScheme,SLOT(mapStopDragging()));
    }

    //MapScheme->setStyleSheet(TOOLBAR_STYLE.arg(Config.appIconSize));

    map->extractFiles(map->params.mapFile,FileName,map->params.mapPath);
    MapScheme->loadMapImageToPaintCmd(FileName,MapScheme->paintBkg);
    MapScheme->horizontalScrollBar()->setValue(MapScheme->horizontalScrollBar()->maximum()/2);
    MapScheme->verticalScrollBar()->setValue(MapScheme->verticalScrollBar()->maximum()/2);
    MapScheme->state.mapLoaded=1;
    Tabs->addTab(MapScheme,key);
    new TMobileUi(this,MapScheme,1);
   }
  }else
   AllText+=QString("<h3>%1</h3><br>%2<br>").arg(key).arg(Info.Value);
 }

 int TextLength=AllText.length();
 if(TextLength>0) infoAddTab(Tabs,(MobileVersion ? tr("Information"):tr("All")),AllText);

 if(TextLength>200 && !MobileVersion)
 {
  QToolBox *Cats = new QToolBox(DetailsWindow);
  QScrollArea *Scroll=new QScrollArea(DetailsWindow);
  Tabs->addTab(Scroll,tr("Categories"));
  Scroll->setWidgetResizable(1);
  Scroll->setWidget(Cats);

  foreach(QString key,map->nodeClick->Info.keys())
  {
   TMapNode::InfoItem Info=map->nodeClick->Info.value(key);
   if(Info.Type==TMapNode::itText)
        infoAddTab(Cats,key,Info.Value);
   else continue;
  }
 }
 if(Tabs->count()) DetailsWindow->showMaximized();

//qDebug() << testTimer.elapsed();
}

void MainWindow::closeEvent(QCloseEvent * e)
{
 if(!isVisible()) { e->accept(); return;} // FIX: double exec dont know why
 map->state.mapLoaded=0;
 if(ui->dock->isVisible()) Config.dockWidth=ui->dock->width();
 setVisible(0);
 QSettings ini(appConfigFile,QSettings::IniFormat);
 ini.setIniCodec(codePage);
 QString key;
 ini.beginGroup("Main");
 ini.setValue("WindowState", saveState().toHex());
 if(!MobileVersion) ini.setValue("WindowGeometry", saveGeometry().toHex());
 ini.setValue("MapLastFile",map->params.mapFile);
 key="Locale";
 if(ini.contains(key))
  ini.setValue(key,Config.locale);
 else
  if(Config.locale!=QLocale::system().name().section("_",0,0)) ini.setValue(key,Config.locale);
 ini.setValue("DockWidth",Config.dockWidth);
 key="MapZoomFactor";
 if(ui->mSaveScale->isChecked())
  ini.setValue(key,QString::number(map->params.mapZoomFactor));
 else ini.remove(key);
 key="MapPosition";
 if(ui->mSavePosition->isChecked())
      ini.setValue(key,QPoint(map->horizontalScrollBar()->value(),map->verticalScrollBar()->value()));
 else ini.remove(key);
 if(MobileVersion) ini.setValue("Styles",TOOLBAR_STYLE);
 if(AppConfig.value(igOther).value(ikMCleanCache).toInt()) removeDir(cachePath);
 else
 if(map->config.enableCaching && !QFile::exists(map->params.mapPath+".cache"))
  map->CachedMap->save(map->params.mapPath+".cache","PNG");
 map->clearMap();

 //setVisible(0);
 e->accept();
}

void applySettings(const IniSettingMap &settings)
{
 TMapView *map=mainWnd->map;
 if(!settings.count()) return;

 QFont nodeFont;
 QMapIterator<IniGroup,IniKeyMap> i(settings);
 while (i.hasNext())
 {
  i.next();
  QMapIterator<IniKey,QString> j(i.value());
  while (j.hasNext())
  {
   j.next();
   QString value=j.value();
   //qDebug() << value;
   if(value.isEmpty()) continue;

   switch(j.key())
   {
   case ikStationCustomFont: map->config.enableCustomFont=value.toInt(); break;
   case ikStationFont: nodeFont.fromString(value); break;
   case ikStationBack: map->config.enableStationBackColor=value.toInt(); break;
   case ikStationShadow: map->config.enableStationShadowColor=value.toInt(); break;
   case ikSBackColor: map->params.nodeColorBack.setNamedColor(value); break;
   case ikSShadowColor: map->params.nodeColorShadow.setNamedColor(value); break;
   case ikSUpperCase: nodeFont.setCapitalization(( value.toInt() ? QFont::AllUppercase:QFont::MixedCase)); break;
   case ikSWordWrap: map->params.nodeFontStyle=(value.toInt() ? Qt::TextWordWrap:Qt::TextSingleLine)+Qt::TextDontClip; break;
   case ikMBackColor:
   {
    map->params.mapColorBack.setNamedColor(value);
    QPalette palette;
    palette.setColor(map->backgroundRole(), map->params.mapColorBack);
    map->setPalette(palette);
   } break;
   case ikSTransparency: map->config.valueTransparency=value.toInt(); break;
   case ikMShowScrollbar: map->config.enableShowScrollBar=value.toInt(); break;
   case ikMShowTime: map->config.enableWriteTime=value.toInt(); break;
   case ikMShowBackground: map->config.enableDrawBackground=value.toInt(); break;
   case ikMAntialiasing: map->config.enableAntialiasing=value.toInt(); break;
   case ikMFastScrolling: map->config.enableLowqDrag=value.toInt(); break;
   case ikMSimpleTransfers: map->config.enableSimpleTransfer=value.toInt(); break;
   case ikMLastFile: map->config.mapLastFile=value; break;
   case ikMCaching: map->config.enableCaching=value.toInt(); break;
   case ikWUiScale: mainWnd->setScaleForUi((qreal)value.toFloat()); break;
   default: break;
   }
  }
 }

 map->applyConfig(); // + load last map

 // change params
 if(map->config.enableCustomFont)
      map->params.nodeFont=nodeFont;
 else map->params.nodeFont=map->params.nodeFontDefault;

}

void saveSettings(const IniSettingMap &settings)
{
 QSettings cfg(appConfigFile,QSettings::IniFormat);
 cfg.setIniCodec(mainWnd->codePage);
 if(AppConfig.count())
 {
  QMapIterator<IniGroup,IniKeyMap> i(AppConfig);
  while (i.hasNext())
  {
   i.next();
   AppConfig.remove(i.key());
  }
  AppConfig.clear();
 }

 if(settings.count())
 {
  QMapIterator<IniGroup,IniKeyMap> i(settings);
  while (i.hasNext())
  {
   i.next();
   AppConfig.insert(i.key(),i.value());
  }
 }


 QMapIterator<IniGroup,IniKeyMap> i(AppConfig);
 while (i.hasNext())
 {
  i.next();
  cfg.beginGroup(IniGroupStr[i.key()]);
  //qDebug() << IniGroupStr[i.key()];
  QMapIterator<IniKey,QString> j(i.value());
  while (j.hasNext())
  {
   j.next();
   cfg.setValue(IniKeyStr[j.key()],j.value());
   //qDebug() << IniKeyStr[j.key()]+"="+j.value();
  }
  cfg.endGroup();
 }
}

void loadSettings()
{
 TMapView *map=mainWnd->map;
 map->defaultConfig();

 QSettings cfg(appConfigFile,QSettings::IniFormat);
 cfg.setIniCodec(mainWnd->codePage);

 foreach(QString group, cfg.childGroups())
 {
  IniKeyMap keys;
  cfg.beginGroup(group);
  //qDebug() << ">>" << group << IniGroupStr.indexOf(group);
  foreach(QString key, cfg.allKeys())
  {
   //qDebug() << key << (IniKey)IniKeyStr.indexOf(key) << cfg.value(key).toString();
   keys.insert((IniKey)IniKeyStr.indexOf(key),cfg.value(key).toString());
  }
  AppConfig.insert((IniGroup)IniGroupStr.indexOf(group),keys);
  cfg.endGroup();
 }

 applySettings(AppConfig);
 if(AppConfig.value(igMapView).value(ikStationFont).isEmpty())
 {
  IniKeyMap FontKey;
  FontKey.insert(ikStationFont,map->params.nodeFont.toString());
  AppConfig.insert(igMapView,FontKey);
 }
 map->applyConfig();
}

bool removeDir(const QString &DirName)
{
 bool Result=1;
 QDir Dir(DirName);

 if (Dir.exists(DirName))
 {
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::System | QDir::Hidden  | QDir::AllDirs | QDir::Files, QDir::DirsFirst))
  {
   if (info.isDir())
        Result=removeDir(info.absoluteFilePath());
   else Result=QFile::remove(info.absoluteFilePath());

   if (!Result) return Result;
  }
  Result=Dir.rmdir(DirName);
 }

 return Result;
}

qint64 sizeOfDir(const QString &DirName)
{
 qint64 Result=0;
 QDir Dir(DirName);

 if (Dir.exists())
  foreach(QFileInfo info, Dir.entryInfoList(QDir::NoDotAndDotDot | QDir::System | QDir::Hidden  | QDir::AllDirs | QDir::Files, QDir::DirsFirst))
  {
   if (info.isDir())
        Result+=sizeOfDir(info.absoluteFilePath());
   else Result+=info.size();
  }

 return Result;
}

void MainWindow::on_mAddMap_triggered()
{
 QString MapPath=appPath+"map/";
 if(Config.locale!="ru")
      QDesktopServices::openUrl(QUrl(URL_TRANSLATE.arg(Config.locale).arg(URL_MAPS)));
 else QDesktopServices::openUrl(QUrl(URL_MAPS));
 MapPath=QDir::toNativeSeparators(MapPath);
 QMessageBox::information(this,tr("Add maps"),tr("1. Wait until loaded site...\n2. Select map\n3. Save file map here:")+"\n     "+MapPath);
}


void MainWindow::on_mFullScreen_toggled(bool checked)
{
 //bool b=windowState()!=Qt::WindowFullScreen;
 if(MobileVersion) ui->mExit->setVisible(checked);
 else (checked ? ui->toolBar->addAction(ui->mExit):ui->toolBar->removeAction(ui->mExit));

 if(checked) showFullScreen();
 else        showMaximized();
}

void MainWindow::setScaleForUi(qreal UiScale)
{
 if(UiScale<=qreal(0.0)) return;

 QFont font=Config.appFont;
 Config.appIconSize=ICONSIZE*UiScale;
 font.setPointSizeF(font.pointSizeF()*UiScale);
 qApp->setFont(font);
 if(MobileVersion && mUi)
      mUi->setToolbarIconSize(Config.appIconSize);
 else ui->toolBar->setIconSize(QSize(Config.appIconSize,Config.appIconSize));
 Config.appUiScale=UiScale;
}
