#include <QDebug>
#include <QtGui>
#include "mobileui.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"

extern MainWindow *mainWnd;
extern QString TOOLBAR_STYLE;
//extern TMapView *map;

TMobileUi::TMobileUi(QWidget *parent,TMapView *map,int type) : MapView(map)
{Q_UNUSED(parent);
 int Spacing=mainWnd->Config.appIconSize/4;
 DefaultIconSize=QSize(mainWnd->Config.appIconSize,mainWnd->Config.appIconSize);

 lTop =new QHBoxLayout;
 lBottom =new QHBoxLayout;
 lLeft =new QVBoxLayout;
 lRight =new QVBoxLayout;
 lToolbar =new QGridLayout;
 bZoomOut = new QToolButton(this);
 bZoomIn = new QToolButton(this);
 bFit = new QToolButton(this);
 bSave = new QToolButton(this);
 bZoomOut->setIcon(QIcon(":/img/zoom-out.png"));
 bZoomIn->setIcon(QIcon(":/img/zoom-in.png"));
 bFit->setIcon(QIcon(":/img/zoom-fit-best.png"));
 bSave->setIcon(QIcon(":/img/document-save.png"));
 bZoomOut->setAutoRepeat(1);
 bZoomIn->setAutoRepeat(1);
 bZoomOut->setShortcut(QKeySequence::ZoomOut);
 bZoomIn->setShortcut(QKeySequence::ZoomIn);
 connect(bSave,SIGNAL(clicked()),map,SLOT(saveToFile()));
 connect(bZoomOut,SIGNAL(clicked()),map,SLOT(zoomOut()));
 connect(bZoomIn,SIGNAL(clicked()),map,SLOT(zoomIn()));
 connect(bFit,SIGNAL(clicked()),map,SLOT(fitMap()));

 if(!type) // MobileVersion UI
 {
  Ui::MainWindow *ui=mainWnd->ui;
  ui->menuFile->removeAction(ui->mExit);
  ui->menuFile->removeAction(ui->mClear);
  //ui->menuHelp->setTitle(tr("Help"));
  ui->toolBar->setVisible(0);

  lTop->addWidget(createButtonFromAction(ui->mFind));
  lTop->addSpacing(Spacing);
  ui->eSearch->setVisible(0);
  //ui->eSearch->setMaximumWidth(maximumWidth());
  lTop->addWidget(ui->eSearch);
//  lTop->addWidget(createButtonFromAction(ui->mClear));
  lTop->addStretch();
  lTop->addWidget(createButtonFromAction(ui->mExit));
  ui->mExit->setVisible(0);
  bExit->setVisible(0);

  lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomOut);
  lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomIn);
  lLeft->addStretch();

  lRight->addWidget(createButtonFromAction(ui->mClear));

  textDescription = new QLabel("");
  textDescription->setMinimumWidth(0);
  textDescription->setMinimumHeight(0);
  //textDescription->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
  textDescription->setAlignment(Qt::AlignCenter);
  textDescription->setVisible(0);

  lBottom->addWidget(bFit);
  lBottom->addSpacing(Spacing);
  lBottom->addStretch();
  lBottom->addWidget(textDescription);
  lBottom->addStretch();
  lBottom->addSpacing(Spacing);
  lBottom->addWidget(createButtonFromAction(ui->mFullScreen));

#if defined(Q_WS_MAEMO_5)
  //  bZoomIn->setShortcut(QKeySequence(Qt::Key_F7));
  //  bZoomOut->setShortcut(QKeySequence(Qt::Key_F8));
  QIcon icoFullScreen=QIcon::fromTheme(QLatin1String("general_fullsize"));
  if(!icoFullScreen.isNull()) ui->mFullScreen->setIcon(icoFullScreen);
  QIcon icoClose=QIcon::fromTheme(QLatin1String("general_close"));
  if(!icoClose.isNull()) ui->mExit->setIcon(icoClose);
  ui->textDescription->setTextInteractionFlags(Qt::TextSelectableByKeyboard);
#endif

  connect(map,SIGNAL(trackFinded(bool)),textDescription,SLOT(setVisible(bool)));
  connect(map,SIGNAL(trackInfo(QString)),textDescription,SLOT(setText(QString)));
  connect(bFullscreen,SIGNAL(toggled(bool)),bExit,SLOT(setVisible(bool)));
  connect(ui->mFind,SIGNAL(toggled(bool)),map->scene,SLOT(update()));

 }
 if(type) // Details
 {
  lTop->addWidget(bZoomOut);
  lTop->addStretch();
  lTop->addWidget(bSave);

  //lLeft->addSpacing(Spacing);
  lLeft->addWidget(bZoomIn);
  lLeft->addStretch();

  lBottom->addWidget(bFit);
  lBottom->addStretch();;
 }

 lToolbar->setMargin(2);
 lToolbar->addItem(lTop,0,0,1,3);
 lToolbar->addItem(lLeft,1,0);
 lToolbar->addItem(lRight,1,2);
 lToolbar->addItem(lBottom,2,0,1,3);

 map->setLayout(lToolbar);
 setToolbarIconSize(mainWnd->Config.appIconSize);

}
TMobileUi::~TMobileUi()
{

}

QToolButton* TMobileUi::createButtonFromAction(QAction *Action,bool AutoRepeat)
{
 QToolButton *button=new QToolButton(this);
 button->setDefaultAction(Action);
 button->setIconSize(DefaultIconSize);
 button->setAutoRepeat(AutoRepeat);
 if(Action==mainWnd->ui->mExit) bExit=button;
 if(Action==mainWnd->ui->mFullScreen) bFullscreen=button;
 return button;
}

void TMobileUi::setToolbarIconSize(int Size)
{
 if(!bZoomOut) return;
 QSize IconSize=QSize(Size,Size);
 MapView->setStyleSheet(TOOLBAR_STYLE.arg(Size));
 QList<QToolButton *> buttons =  MapView->findChildren<QToolButton *>();
 foreach(QToolButton *b,buttons)
 {
  b->setIconSize(IconSize);
 }
}
