TARGET = qMetro
TEMPLATE = app
DESTDIR = bin

#include(rc/locale.pri)

SOURCES +=	src/main.cpp\
		src/mainwindow.cpp \
		src/zip/unzip.cpp \
		src/mapview/mapview.cpp \
    src/mapview/maproute.cpp \
    src/mapview/mapgraphics.cpp \
    src/mapview/mapnode.cpp \
    src/mapview/mapedge.cpp \
    src/mapview/maplayer.cpp \
    src/mapview/mapelement.cpp \
    src/completer.cpp \
    src/settings.cpp \
    src/details.cpp \
    src/ini/inisettings.cpp \
    src/mobileui.cpp \
    src/flickcharm.cpp \
    src/zip/zipglobal.cpp \
    src/zip/zip.cpp

HEADERS  +=	src/mainwindow.h \
		src/zip/unzip.h \
		src/zip/unzip_p.h \
		src/mapview/mapview.h \
    src/mapview/maproute.h \
    src/mapview/mapgraphics.h \
    src/mapview/mapnode.h \
    src/mapview/mapedge.h \
    src/mapview/maplayer.h \
    src/mapview/mapelement.h \
    src/completer.h \
    src/settings.h \
    src/details.h \
    src/ini/inisettings.h \
    src/mobileui.h \
    src/flickcharm.h \
    src/about.h \
    src/zip/zipglobal.h \
    src/zip/zipentry_p.h \
    src/zip/zip_p.h \
    src/zip/zip.h

FORMS    += ui/mainwindow.ui \
            ui/settings.ui \
            ui/details.ui

RESOURCES += rc/resource.qrc

DEFINES += OPENGL_ENABLE=0

win32{
 #QT += opengl
 QMAKE_LFLAGS += -static-libgcc
 win32-g++:DEFINES += QT_NEEDS_QMAIN
 win32-borland:DEFINES += QT_NEEDS_QMAIN
 RC_FILE = rc/icon.rc
}
unix:!macx:!symbian {
	TARGET = qmetro
	isEmpty(PREFIX):PREFIX = /usr
	BINDIR = $$PREFIX/bin
	DATADIR = $$PREFIX/share
	maemo5 {
		#QT += opengl
		BINDIR = /opt/maemo/usr/bin
		DATADIR = /home/user/tmp/qMetro
	}

	#DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

	#MAKE INSTALL
	INSTALLS += target desktop icons locale map

	target.path =$$BINDIR

	desktop.path = $$DATADIR/applications
	maemo5: desktop.path = $$PREFIX/share/applications/hildon
	desktop.files = rc/qmetro.desktop
	
	#maemo5: PREFIX = /opt/usr
	icons.path = $$PREFIX/share/icons
	icons.files += rc/icons/*

	locale.path = $$DATADIR/$$TARGET/locale
	locale.files += bin/locale/es.lng bin/locale/fr.lng
	map.path = $$DATADIR/$$TARGET/map
	map.files += bin/map/Moscow.pmz
	maemo5 {
		locale.path = $$DATADIR/locale
		map.path = $$DATADIR/map
	}

}
macx{
 QMAKE_INFO_PLIST = rc/Info.plist
 ICON = rc/icon.icns
}
symbian: include(rc/symbian.pri)
