#ifndef MAP_H
#define MAP_H

//#include <QDebug>
#include <QtGui/QGraphicsView>
#include <QTimer>

#include "mapelement.h"

class TMapLayer;
class TMapRoute;
class TMapNode;
class TMapEdge;
//class TMapElement;


enum DrawType
{dtPenColor,dtBrushColor,dtLine,dtPolygon,dtSpline,dtEllipse,dtTextOut,dtAngleTextOut,
 dtPeOpaqueAngleTextOut,dtImage,dtRailway,dtStairs,dtSpotRect,dtAngle,dtTranslate,dtPath,dtArrow,dtSpotCircle};

struct TPaintCmd
{
  QString param;
  DrawType type;

  QList<qreal> nums;
  QList<QColor> colors;
  QList<QString> strings;

  QPixmap *image;
  QPen pen;
  QBrush brush;
  QFont font;
  QPolygonF polygon;
  QPainterPath path;

};

class TMapView : public QGraphicsView
{
Q_OBJECT
 //friend class TMapElement;
 //friend void TMapElement::drawPaintCmd(QPainter *painter, QList<TPaintCmd> &paintCmd);

private:

    int timerId;

    struct AddCacheEdge
    {
     QString routeName[2];
     QString nodeName[2];
     QPolygon points;
     int edgeStyle;

     QString cost[2];
     bool transfer;

     bool assigned;
    };

    QList<AddCacheEdge*> edgeCache; // cache for additional nodes & transfers
    QHash<QChar, QString> BGN;
    QTextCodec *codePage;
    QString WindowTitle;

    //void drawMapLayer(QPainter *painter, TMapLayer *mapLayer);

    void dijkstra(int nodeBeginID);
    QString convertToTextWithTags(QString text);

public:
    TMapView(QString AppPath, QString CachePath);
    ~TMapView();
    void scaleMap(qreal scaleFactor);

    void defaultConfig();
    void applyConfig();
    void loadMap(QString fileName);
    void loadMapImageToPaintCmd(QString imageFile, QList<TPaintCmd> &paintCmd);
    void loadMapLayers(QString LayerFilesTRP); // !! IN LAYER CLASS
    void loadNodeInfo(TMapNode *node);

    void clearMap(); // !! DESTRUCT

    bool extractFiles(QString zipFile, QString extractFiles, QString extractDir);
    void exportMap(QString fileName,QString ext);
    void addPaintCmd(const QString &eParam,DrawType eType,QList<TPaintCmd> &paintCmd);
    void addLayerToPaintCmd(TMapLayer *mapLayer,QList<TPaintCmd> &paintCmd);
    void drawPaintCmd(QPainter *painter, QList<TPaintCmd> &paintCmd);
    int  strTimeToSec(const QString &strTime);

    void findTrack(TMapNode *begin,TMapNode *end=NULL);
    void clearTrack();
    void selectedNodesToFront(bool enable);

    void initTranslit();
    void convertToTranslit(QString &text);

    QTimer TimerPopup;

    QList<TMapLayer*> layer;
    QList<TPaintCmd> paintBkg,paintMap;
    QList< QPair<QString,QColor> > getNamesAndColors();

    QVector< QVector<TMapEdge*> > mapGraph;
    QVector< QVector<qreal> > workGraph;
    QVector<qreal> mapDistance;
    QVector<int> mapParentNode;
    QVector<TMapNode*> nodeByID;
    QList<TMapNode*> selectedNode;
    QList<TMapEdge*> selectedEdge;

    QGraphicsScene *scene;
    QPixmap *CachedMap;

    struct TParams
    {
     QString mapFile;
     QString mapPath;
     QString mapCachePath;
     QString mapName;
     QString mapCityName;
     QString mapCountryName;
     QString mapRusName;
     QString mapNeedVersion;
     QString mapAuthors;
     QString mapDelayNames;
     QColor  mapColorBack;
     bool    mapIsVector;
     qreal   mapZoomFactor;

     int    nodeWidth;
     qreal  nodeConstructWidth;
     QFont  nodeFont;    // +UpperCase
     QFont  nodeFontDefault;
     int    nodeFontStyle; // +WordWrap
     QColor nodeColorBack;
     QColor nodeColorShadow;
     bool   nodeUpperCase;
     bool   nodeWordWrap;

     int routeWidth;

     QString Transports;
     QString CheckedTransports;

     QString appPath;
     QString appName;

     int delayMetro;
     int delayIndex;
    };

    TParams params;

    struct TConfig
    {
     QString mapLastFile;

//     QFont fontNode;
     int valueTransparency;

     bool enableCustomFont;
     bool enableStationBackColor;
     bool enableStationShadowColor;

     bool enableLowqDrag;
     bool enableDrawBackground;
     bool enableShowScrollBar;
     bool enableAntialiasing;
     bool enableSimpleTransfer;
     bool enableSimpleNode;
     bool enableWriteTime;
     bool enableTranslit;
     bool enableCaching;

     bool MobileVersion;
     QString locale;


     //bool enableTransliterate;
     //bool enableCaptionHint;
    };
    TConfig config;

    struct TMapState
    {
     bool mapLoaded;
     bool mapCached;
     bool mapDragging;
     bool nodeClick;
    };
    TMapState state;

    QPoint nodeClickPos;
    int nodeBeginID, nodeEndID;
    TMapNode *nodeBegin,*nodeEnd,*nodeClick;
    TMapElement *mapFade;

    QAction *nodeAInfo;
    QMenu *nodePopup;

public slots:
 void setDelayMetro(int delay);
 void setDelayIndex(int index);
 void zoomIn();
 void zoomOut();
 void fitMap();
 void setNodeBegin();
 void setNodeEnd();
 void popupByTimer();
 void saveToFile();
 void findTrackByID(int ID) { findTrack(nodeByID[ID]); }
 void findedNodesToFront(QList<int> NodeID);
 void mapStartDragging();
 void mapStopDragging();

signals:
 void trackInfo(QString Info);
 void trackDescription(QString Description);
 void trackText(QString Text);
 void trackFinded(bool Check);
 void delayNames(QStringList);
 void nodeClicked(bool VisibleLayer);

protected:
    void keyPressEvent(QKeyEvent *event);
    void wheelEvent(QWheelEvent *event);
    void drawBackground(QPainter *painter, const QRectF &rect);
    //void drawForeground(QPainter *painter, const QRectF &rect);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    //void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event);


    int mapWidth,mapHeight;

};

#endif
