#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "mapview/mapview.h"

namespace Ui {
    class MainWindow;
}

enum IniGroup{igMapView,igMain,igOther};
enum IniKey{ikStationCustomFont,ikStationFont,ikStationBack,ikStationShadow,ikSBackColor,ikSShadowColor,
            ikSUpperCase,ikSWordWrap,ikSTransparency,
            ikMShowScrollbar,ikWFullScreen,ikMShowTime,ikMShowBackground,ikMAntialiasing,ikMFastScrolling,
            ikMBackColor,ikMSimpleTransfers,ikMCleanCache,ikMLastFile,ikMCaching,ikWUiScale};

typedef QMap<IniKey,QString> IniKeyMap;
typedef QMap<IniGroup,IniKeyMap> IniSettingMap;

void applySettings(const IniSettingMap &settings);
void saveSettings(const IniSettingMap &settings);
void loadSettings();

bool removeDir(const QString &DirName);
qint64 sizeOfDir(const QString &DirName);

class TElement;
class TCompleter;
class Settings;
class TMobileUi;

class MainWindow : public QMainWindow
{Q_OBJECT
friend class TMobileUi;
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    //void showEvent(QShowEvent * event);

    TMapView *map;
    Settings *SettingWindow;

    struct TConfig
    {
     QString locale;
     int dockWidth;
     qreal mapZoomFactor;
     QPoint mapPosition;
     bool mapZoomFactorCheck;
     bool mapPositionCheck;
     bool mapKineticScrollCheck;

     QFont appFont;
     qreal appUiScale;
     int appIconSize;

     QSize mainWindow;
     QSize settingWindow;
    };
    TConfig Config;

    bool MobileVersion;
    TMobileUi *mUi;

protected:
    //bool event(QEvent *e);
    bool eventFilter(QObject *obj, QEvent *event);

private:
    Ui::MainWindow *ui;
    void closeEvent(QCloseEvent * e);

    TCompleter *Completer;

public slots:
    void setScaleForUi(qreal UiScale);
    void setScaleForUi(int UiScale) { setScaleForUi((qreal)(UiScale/100.0)); }
    void toggleLang(QString locale="");

private slots:

    void on_mFullScreen_toggled(bool checked);
    void on_mAddMap_triggered();
    void on_mPreference_triggered();
    void on_bClear_clicked();
    void on_mAbout_triggered();
    void on_mFind_toggled(bool checked);
    void on_eSearch_returnPressed();
    void on_mTest_triggered();
    void on_mSave_triggered();
    void on_mOpen_triggered();
    void on_mExit_triggered();
    void setDelayNames(QStringList list);
    void nodeInformation();

};

#endif // MAINWINDOW_H
