#ifndef ABOUT_H
#define ABOUT_H

#include <QtGui>
#include <QDialog>

#include "mainwindow.h"
#include "flickcharm.h"

extern MainWindow *mainWnd;
extern QString VERSION;
extern QString URL_MAPS;


class About : public QDialog
{
    Q_OBJECT

public:
    explicit About(QWidget *parent): QDialog(parent)
    {
     OK= new QPushButton();
     Logo= new QLabel();
     Info= new QTextBrowser();

     setWindowTitle(tr("About")+" qMetro");
#ifdef Q_WS_MAEMO_5
     setAttribute(Qt::WA_Maemo5StackedWindow);
     setWindowFlags(Qt::Window);
     setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif


    #ifndef Q_WS_MAEMO_5
     FlickCharm *fcharm=new FlickCharm(Info);
     fcharm->activateOn(Info);
    #endif

     setWindowFlags(windowFlags() & (~Qt::WindowContextHelpButtonHint));
     setFixedWidth(500);
     setMinimumHeight(155);
     setFixedHeight(400);

     Logo->setFixedWidth(64);
     Logo->setContentsMargins(0,5,0,0);
     Logo->setPixmap(QPixmap(":/qmetro.png"));

     QString hr=QString("<p><table height=2 width=100% bgcolor=%1><tr><td></table></p>")
                .arg(palette().color(QPalette::Mid).name());
     QString text=
     QString("<p><font size=6><b>qMetro</b></font> - %4.</p>"
             "<p>%5 %1 &copy; 2011 <a href=\"mailto:guuleon@gmail.com\">Gusak Leonid</a>"
             " - <a href=\"http://qmetro.sf.net\">qmetro.sf.net</a></p>"
             "<p>%6: <a href=\"mailto:Boris@pMetro.su\">Muradov Boris</a>"
             " - <a href=\"%10\">pMetro</a></p>"
             "<p>%11</p>"
             "<hr><b>%7:</b>"
             "<p>%3</p>"
             "<hr><b>%8:</b><ul type=\"circle\"><li>&nbsp;Qt %2<li>&nbsp;zlib + OSDaB</ul>"
             "<hr>%9")
     .arg(VERSION).arg(QT_VERSION_STR).arg((mainWnd->map->params.mapAuthors.isEmpty() ? tr("Unknown author"):mainWnd->map->params.mapAuthors)) // 1
     .arg(tr("transit system map")).arg(tr("Version")).arg(tr("Author of map file format")) // 3
     .arg(tr("About current map file")).arg(tr("This program uses")) // 6
     .arg(tr("This program is distributed in the hope that it will be useful, "
             "but WITHOUT ANY WARRANTY; without even the implied warranty of "
             "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
             "GNU General Public License for more details.")).arg(URL_MAPS).arg(tr("Author of translation: Gusak Leonid"));

     text.replace("<hr>",hr);

     QPalette pal = Info->palette();
     pal.setBrush(QPalette::Base, Qt::transparent);
     pal.setColor(QPalette::Text,palette().color(QPalette::Text));
     Info->setPalette(pal);
     Info->setAttribute(Qt::WA_NoSystemBackground);
     Info->setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
     Info->setOpenExternalLinks(1);
     Info->setReadOnly(1);
     Info->setFrameShape(QFrame::NoFrame);
     Info->setText(text);

     HLayout= new QHBoxLayout;
     VLayout= new QVBoxLayout;
     HLayout->addWidget(Logo);
     HLayout->setAlignment(Logo,Qt::AlignTop);
     VLayout->addWidget(Info);
#ifndef Q_WS_MAEMO_5
     OK->setText(tr("OK"));
     OK->setDefault(1);
     OK->setMaximumWidth(75);
     connect(OK,SIGNAL(pressed()),this,SLOT(close()));
     VLayout->addWidget(OK);
     VLayout->setAlignment(OK,Qt::AlignRight);
#endif
     HLayout->addItem(VLayout);
     setLayout(HLayout);

    }
    ~About()
    {
     delete OK;
     delete Logo;
     delete Info;
    }

private:
    void closeEvent(QCloseEvent *e)
    {
     deleteLater();
    }

    QHBoxLayout *HLayout;
    QVBoxLayout *VLayout;
    QPushButton *OK;
    QLabel *Logo;
    QTextBrowser *Info;

protected:
    void keyPressEvent(QKeyEvent *e)
    {
     if(e->key()==Qt::Key_Escape) close();
    }

};

#endif // ABOUT_H
