#include <QDebug>
#include <QGraphicsScene>
#include <QGraphicsSceneMouseEvent>
#include <QPainter>

#include "mapview.h"
#include "maproute.h"
#include "mapnode.h"
#include "mapgraphics.h"

static const QRect  nullR=QRect ();
static const QPoint nullP=QPoint();
extern qreal INFINIT;


TMapNode::TMapNode(TMapView *nodeMap,TMapRoute *nodeRoute, QString nodeName, int nodeID)
 : NodeWidth(20), NodeHeight(20)
{
 ID=nodeID;
 Name = nodeName;
 Route=nodeRoute;
 TypeNode=ntConstruct;
 HasTransfer=0;

 setPos(QPoint(0,0));
 //setFlag(ItemIsSelectable);
 setFlag(ItemIsFocusable);
 setZValue(-1);
#ifndef Q_OS_WINCE
 setCursor(Qt::PointingHandCursor);
#endif
 //setFlag(ItemSendsGeometryChanges);
 setCacheMode(DeviceCoordinateCache);
 setBoundingRegionGranularity(1);

 Map=nodeMap;
 NRect=nullR;
 Rect=nullR;
}
void TMapNode::init()
{
 QPainter p; // fake
 int sWidth=Map->params.nodeWidth;
 QRectF r;
 bool leftAlign=0;

 DisplayName=(Alias.isEmpty() ? Name:Alias);
 if(Map->config.enableTranslit) Map->convertToTranslit(DisplayName);
 if(!Map->config.MobileVersion) setToolTip(DisplayName);

 NRect=QRect(Rect.topLeft()-pos().toPoint()-QPoint(1,0),QSize(Rect.width(),Rect.height()));
 EllipseRect=QRect(QPoint(-sWidth,-sWidth),QPoint(sWidth,sWidth));
 Align=Map->params.nodeFontStyle;
 Vertical=0;

 if(NRect.width()<NRect.height())
 {
  if(NRect.topLeft().y()<-sWidth)
  {
   NRect90=QRect(NRect.bottomRight()+QPoint(3,3),QSize(NRect.height()+NRect.width()+10,NRect.width()*2));
   Vertical=-1;
  }
  else
  {
   NRect90=QRect(NRect.topRight()+QPoint(3,-NRect.width()),QSize(NRect.height()+NRect.width()+10,NRect.width()*2));
   Vertical=1;
  }
  Align+=Qt::AlignLeft;

  QMatrix matrix;
  QPainterPath pRect;

  p.setFont(Map->params.nodeFont);
  p.drawText(NRect90,Align,DisplayName,&NRect90);

  pRect.addRect(NRect90);
  matrix.rotate(90*Vertical);
  pRect=matrix.map(pRect);
  NRect=pRect.boundingRect().toRect();

 }else
 if(Rect.center().x()-sWidth>pos().x()) Align+=Qt::AlignLeft; else Align+=Qt::AlignRight;
 r=shape().boundingRect();
 prepareGeometryChange();
 NodeWidth=r.width();
 NodeHeight=r.height();

 if(Map->config.enableSimpleNode)
 {
//  const int size=int(Map->conf.StationWidth/2);
//  QPolygon points(7);
//  points[0] = QPoint(2*size,0);
//  points[1] = QPoint(size,-size*173/100);
//  points[2] = QPoint(-size,-size*173/100);
//  points[3] = QPoint(-2*size,0);
//  points[4] = QPoint(-size,size*173/100);
//  points[5] = QPoint(size,size*173/100);
//  points[6] = points[0];
//  PathNode.addPolygon(points);
  const int Width=Map->params.nodeWidth;
  PathNode.addRect(QRect(-Width,-Width,Width*2,Width*2));
 }
 else
  PathNode.addEllipse(nullP, Map->params.nodeWidth,Map->params.nodeWidth);
}

QRectF TMapNode::boundingRect() const
{
 return shape().boundingRect();
}

QPainterPath TMapNode::shape() const
{
 QPainterPath path;
 int more=(ID==Map->nodeBeginID || ID==Map->nodeEndID ? Map->params.nodeWidth/2:1);
 path.addEllipse(nullP, Map->params.nodeWidth+more,Map->params.nodeWidth+more);
 path.addRect(NRect);
 return path;
}

void TMapNode::paint(QPainter *p, const QStyleOptionGraphicsItem *option, QWidget *)
{
 if(!Map->state.mapLoaded) return;

 if(HasTransfer) p->setPen(QPen(Qt::white,1));
 else            p->setPen(QPen(Qt::yellow,1));

 p->setBrush(Route->color);

 if(TypeNode==ntConstruct)
 {
  p->setPen(QPen(Qt::gray,1));
  p->setBrush(Qt::white);
 }else
 if(Map->nodeBeginID==ID)
 {
  p->setPen(QPen(Qt::green,Map->params.nodeWidth/qreal(2)));
  p->setBrush(Qt::black);
 }else
 if(Map->nodeEndID==ID)
 {
  p->setPen(QPen(Qt::red,Map->params.nodeWidth/qreal(2)));
  p->setBrush(Qt::black);
 }

 p->drawPath(PathNode);
 if(Map->config.enableWriteTime && Map->nodeBegin && TypeNode!=ntConstruct && Map->mapDistance.count())
 {
  QFont f=Map->params.nodeFont;
  p->setPen(Qt::white);
  f.setPointSize(Map->params.nodeWidth);
  p->setFont(f);
  int dist=Map->mapDistance[ID];
  if(dist<INFINIT)
    p->drawText(EllipseRect,Qt::AlignCenter,QString::number(int(dist/60)));                                          //QString::number(ID));
 }
 //else { p->setFont(QFont("Tahoma",5)); p->drawText(EllipseRect,Qt::AlignCenter,QString::number(int(ID)));}

 if(Rect!=nullR)
 {
  QRectF TextRect;
  p->setFont(Map->params.nodeFont);
  p->setBrush(Route->labelsBColor);

  if(Vertical)
  {
   p->rotate(90*Vertical);
   TextRect=NRect90;
  }else TextRect=NRect;

  if(Map->config.enableCustomFont)
  {
   if(Map->config.enableStationBackColor)
   {
    p->setBackgroundMode(Qt::OpaqueMode);
    p->setBackground(Map->params.nodeColorBack);
   }
  }
  else // backcolor
  if(Route->labelsBColor.alpha()) p->setBackgroundMode(Qt::OpaqueMode);
  else // shadow
  {
   p->setBackgroundMode(Qt::TransparentMode);
   p->setPen(Qt::white);
   p->drawText(TextRect.adjusted(-0.4,-0.4,-0.4,-0.4),Align,DisplayName);

   p->setPen(Route->color.dark());
   p->drawText(TextRect.adjusted(0.3,0.3,0.3,0.3),Align,DisplayName);
  }

  if(Map->config.enableCustomFont && Map->config.enableStationShadowColor)
  {
   p->setBackgroundMode((Map->config.enableStationBackColor ? Qt::OpaqueMode:Qt::TransparentMode));
   p->setPen(Map->params.nodeColorShadow);
   p->drawText(TextRect.adjusted(0.3,0.3,0.3,0.3),Align,DisplayName);
   p->setBackgroundMode(Qt::TransparentMode);
  }

  p->setPen(Route->color);
  if(Vertical)
       p->drawText(NRect90,Align,DisplayName,&NRect90);
  else p->drawText(NRect,Align,DisplayName,&NRect);
 }
}

int TMapNode::type() const
{
 return elNode;
}


