//#include <QDebug>

#include "completer.h"

TCompleter::TCompleter(QList< QPair<QString,QColor> > data,QLineEdit *parent)
 : QObject(parent), editor(parent), list(data)
{

 popup = new QTreeWidget(parent);
 popup->setWindowFlags(Qt::Popup);
 popup->setFocusPolicy(Qt::NoFocus);
 popup->setFocusProxy(parent);
 popup->setMouseTracking(true);

 popup->setColumnCount(2);
 popup->setUniformRowHeights(true);
 popup->setRootIsDecorated(false);
 popup->setEditTriggers(QTreeWidget::NoEditTriggers);
 popup->setSelectionBehavior(QTreeWidget::SelectItems);
 popup->setFrameStyle(QFrame::Box | QFrame::Plain);
 popup->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
 popup->header()->hide();
 popup->installEventFilter(this);

 connect(popup, SIGNAL(itemClicked(QTreeWidgetItem*,int)),SLOT(doneCompletion()));

 timer = new QTimer(this);
 timer->setSingleShot(true);
 timer->setInterval(500);
 connect(timer, SIGNAL(timeout()), SLOT(autoSuggest()));
 connect(editor, SIGNAL(textEdited(QString)), timer, SLOT(start()));

// connect(&networkManager, SIGNAL(finished(QNetworkReply*)),
//         this, SLOT(handleNetworkData(QNetworkReply*)));

}

TCompleter::~TCompleter()
{
 delete popup;
 list.clear();
 idFiltred.clear();
}

bool TCompleter::eventFilter(QObject *obj, QEvent *ev)
{
 if(obj != popup) return false;

 if (ev->type() == QEvent::MouseButtonPress)
 {
  popup->hide();
  editor->setFocus();
  return true;
 }

 if (ev->type() == QEvent::KeyPress)
 {
  bool consumed = false;
  int key = static_cast<QKeyEvent*>(ev)->key();
  switch (key) {
  case Qt::Key_Enter:
  case Qt::Key_Return:
   doneCompletion();
   consumed = true;

  case Qt::Key_Escape:
   editor->setFocus();
   popup->hide();
   consumed = true;

  case Qt::Key_Up:
  case Qt::Key_Down:
  case Qt::Key_Home:
  case Qt::Key_End:
  case Qt::Key_PageUp:
  case Qt::Key_PageDown:
   break;

  default:
   editor->setFocus();
   editor->event(ev);
   popup->hide();
   break;
  }

  return consumed;
 }

 return false;
}

void TCompleter::showCompletion(QList< QPair<QString,QColor> > list)
{
 if (list.isEmpty()) return;

// const QPalette &pal = editor->palette();
// QColor color = pal.color(QPalette::Disabled, QPalette::WindowText);

 popup->setUpdatesEnabled(false);
 popup->clear();
 int FontSize=QFont().pointSize()*2;
 for (int i = 0; i < list.count(); ++i)
 {
  QTreeWidgetItem * item;
  item = new QTreeWidgetItem(popup);
  item->setText(0, list.at(i).first);
#ifdef Q_WS_MAEMO_5
  item->setText(1,"=");
  item->setFont(1,QFont("",FontSize,87));
  item->setTextColor(1, list.at(i).second);
#endif
  item->setBackgroundColor(1,list.at(i).second);
  //item->setIcon(1,); //icon with transparent
  item->setTextAlignment(1, Qt::AlignCenter);
 }
 popup->setCurrentItem(popup->topLevelItem(0));
 popup->resizeColumnToContents(0);
 popup->setColumnWidth(1,15);
 //popup->resizeColumnToContents(1);
 popup->adjustSize();
 popup->setUpdatesEnabled(true);

 int h = popup->sizeHintForRow(0) * qMin(7, list.count()) + 3;
 popup->resize(popup->columnWidth(0)+40, h);

 popup->move(editor->mapToGlobal(QPoint(0, editor->height())));
 popup->setFocus();
 popup->show();
}

void TCompleter::doneCompletion()
{
 timer->stop();
 popup->hide();
 editor->setFocus();
 QTreeWidgetItem *item = popup->currentItem();
 if (item)
 {
  int i=idFiltred.at(popup->currentIndex().row());
  emit doneCompletionByID(i);
  editor->setText(item->text(0));
  QMetaObject::invokeMethod(editor, "returnPressed");
 }
}

void TCompleter::autoSuggest()
{
 showCompletion(filterList(list,editor->text()));
}

void TCompleter::preventSuggest()
{
 timer->stop();
}

QList< QPair<QString,QColor> >
TCompleter::filterList(QList< QPair<QString,QColor> > list, QString filter)
{
 QList< QPair<QString,QColor> > filtred;
 if(filter.trimmed().length()<2) return filtred;
 filter.replace(" ","*");
 QRegExp regExp=QRegExp(filter,Qt::CaseInsensitive,QRegExp::Wildcard);
 idFiltred.clear();
 for(int i=0;i<list.count();i++)
  if(list.at(i).first.contains(regExp))
  {
   filtred << list.at(i);
   idFiltred << i;
  }
 emit doneSuggestByID(idFiltred);
 return filtred;
}

