#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include "mainwindow.h"

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget *parent = 0);
    ~Settings();
    void loadSettings(const IniSettingMap &set);

    Ui::Settings *ui;

private:
    void closeEvent(QCloseEvent * e);
    void updateLabelCacheSize();

    QColor SBackColor,SShadowColor,MBackColor;

protected:
    void keyPressEvent(QKeyEvent *e);

private slots:

    void on_bMEmptyExit_clicked();
    void on_buttonBox_accepted();
    void on_buttonBox_rejected();
    void on_bSFont_clicked();
    void on_bSBackColor_clicked();
    void on_bSShadowColor_clicked();
    void on_bMBackColor_clicked();

    IniSettingMap changeSettings();


};

#endif // SETTINGS_H
