/******************************************************************
* Main Bar
* Author: Nicola De Filippo
* Version: 0.1
* License: GPL
*******************************************************************/

import Qt 4.7

import "/usr/share/qlshop/qmls"

Rectangle {
    id: bar
    width: parent.width
    height: 30 + 20

    signal clickItems;
    signal clickNewList;
    signal clickAddItemShop;
    signal clickInfo;

    color: "black"
    property bool addButtonEnabled: false

    anchors.bottom: parent.bottom
    Row {
        id: buttons
        anchors.verticalCenter: parent.verticalCenter
        anchors.centerIn: parent
        spacing: 10


        TextButton {
            anchors.topMargin: 20
            text: "New shop list"
            onClicked: bar.clickNewList();
            //border.color:"#095f73"
            //border.width: 3
            color: "white"
        }
        TextButton {
            id: addItemButon
            text: "Add item to shop list"
            onClicked: bar.clickAddItemShop();
            enabled: addButtonEnabled
            opacity: {(addButtonEnabled)? 1: 0.7}
            //border.color:"#095f73"
            //border.width: 3
        }
        TextButton {
            text: "Items"
            onClicked: bar.clickItems();
            //border.color:"#095f73"
            color: "white"
            //border.width: 3
        }
        TextButton {
            text: "Info"
            onClicked: bar.clickInfo();
            //border.color:"#095f73"
            color: "white"
            //border.width: 3
        }
        TextButton {
            text: "Exit"
            onClicked: app.quit();
            //border.color:"#095f73"
            color: "white"
            //border.width: 3
        }
    }
}
