/******************************************************************
* Main
* Author: Nicola De Filippo
* Version: 0.1
* License: GPL
*******************************************************************/


#include <QApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include "connection.h"
#include <qlsqltablemodel.h>
#include <QDebug>
#include <QSqlRecord>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QDeclarativeView view;


    createConnection("shoplist");

    QLSqlTableModel *model = new QLSqlTableModel;
    QLSqlTableModel *modelLista = new QLSqlTableModel;
    model->setTable("items");
    model->generateRoleNames();
    model->select();

    modelLista->setTable("lista");
    modelLista->setRelation(2, QSqlRelation("items", "id", "nome"));

    modelLista->select();
    modelLista->generateRoleNames();


    QDeclarativeContext *ctxt = view.rootContext();
    ctxt->setContextProperty("modelListItems", model);


    ctxt->setContextProperty("modelList", modelLista);
    ctxt->setContextProperty("app", &app);


    view.setSource(QUrl::fromLocalFile("/usr/share/qlshop/qmls/Main.qml"));
    view.show();

    return app.exec();
}

